/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.ClusteredListenerWithDslFilterTest")
public class ClusteredListenerWithDslFilterTest
extends MultipleCacheManagersTest {
    private final int NUM_NODES = 3;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = ClusteredListenerWithDslFilterTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createClusteredCaches(3, cfgBuilder);
    }

    public void testEventFilter() {
        MagicKey key;
        Cache cache;
        Person value;
        int i;
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache(0));
        Query query = qf.from(Person.class).having("age").lte((Object)31).toBuilder().build();
        EntryListener listener = new EntryListener();
        for (i = 0; i < 5; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 30);
            cache = this.cache(i % 3);
            key = new MagicKey(cache);
            cache.put((Object)key, (Object)value);
        }
        this.cache(0).addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 3);
            key = new MagicKey(cache);
            cache.put((Object)key, (Object)value);
        }
        Assert.assertEquals((long)9L, (long)listener.results.size());
        for (ObjectFilter.FilterResult r : listener.results) {
            Person p = (Person)r.getInstance();
            Assert.assertTrue((p.getAge() <= 31 ? 1 : 0) != 0);
        }
        this.cache(0).removeListener((Object)listener);
        listener.results.clear();
        Person value2 = new Person();
        value2.setName("George");
        value2.setAge(30);
        MagicKey key2 = new MagicKey(this.cache(0));
        this.cache(0).put((Object)key2, (Object)value2);
        Assert.assertEquals((long)0L, (long)listener.results.size());
    }

    public void testEventFilterAndConverter() {
        MagicKey key;
        Cache cache;
        Person value;
        int i;
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache(0));
        Query query = qf.from(Person.class).having("age").lte((Object)31).toBuilder().select(new String[]{"name", "age"}).build();
        EntryListener listener = new EntryListener();
        for (i = 0; i < 5; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 30);
            cache = this.cache(i % 3);
            key = new MagicKey(cache);
            cache.put((Object)key, (Object)value);
        }
        this.cache(0).addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 3);
            key = new MagicKey(cache);
            cache.put((Object)key, (Object)value);
        }
        Assert.assertEquals((long)9L, (long)listener.results.size());
        for (ObjectFilter.FilterResult r : listener.results) {
            Assert.assertTrue(((Integer)r.getProjection()[1] <= 31 ? 1 : 0) != 0);
        }
        this.cache(0).removeListener((Object)listener);
    }

    @Listener(clustered=true, includeCurrentState=true)
    public static class EntryListener {
        public final List<ObjectFilter.FilterResult> results = new ArrayList<ObjectFilter.FilterResult>();

        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent<?, ObjectFilter.FilterResult> event) {
            if (!event.isPre()) {
                ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
                this.results.add(filterResult);
            }
        }

        @CacheEntryModified
        public void handleEvent(CacheEntryModifiedEvent<?, ObjectFilter.FilterResult> event) {
            if (!event.isPre()) {
                ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
                this.results.add(filterResult);
            }
        }
    }
}

