/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.hql.ParsingException;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.NonIndexedQueryDslConditionsTest")
public class NonIndexedQueryDslConditionsTest
extends QueryDslConditionsTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        this.createClusteredCaches(1, cfg);
    }

    public void testInsertAndIterateInTx() throws Exception {
        final User newUser = this.getModelFactory().makeUser();
        newUser.setId(15);
        newUser.setName("Test");
        newUser.setSurname("User");
        newUser.setGender(User.Gender.MALE);
        newUser.setAge(20);
        List results = (List)TestingUtil.withTx((TransactionManager)this.tm(0), (Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                Query q = NonIndexedQueryDslConditionsTest.this.getQueryFactory().from(NonIndexedQueryDslConditionsTest.this.getModelFactory().getUserImplClass()).not().having("age").eq((Object)20).toBuilder().build();
                NonIndexedQueryDslConditionsTest.this.cache(0).put((Object)("new_user_" + newUser.getId()), (Object)newUser);
                return q.list();
            }
        });
        this.cache(0).remove((Object)("new_user_" + newUser.getId()));
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Override
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Indexing was not enabled on this cache.*")
    public void testIndexPresence() {
        Search.getSearchManager((Cache)((Cache)this.getCacheForQuery())).unwrap(SearchIntegrator.class);
    }

    @Override
    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN000405:.*")
    public void testInvalidEmbeddedAttributeQuery() throws Exception {
        super.testInvalidEmbeddedAttributeQuery();
    }

    @Override
    @Test
    public void testNullOnIntegerField() throws Exception {
        super.testNullOnIntegerField();
    }

    public void testAnd5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").lt((Object)1000).and().having("age").lt((Object)1000).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }
}

