/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.LuceneQuery;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.QueryDslIterationTest")
public class QueryDslIterationTest
extends AbstractQueryDslTest {
    @BeforeClass(alwaysRun=true)
    protected void populateCache() throws Exception {
        User user1 = this.getModelFactory().makeUser();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("White");
        user1.setNotes("Lorem ipsum dolor sit amet");
        User user2 = this.getModelFactory().makeUser();
        user2.setId(2);
        user2.setName("Jack");
        user2.setSurname("Black");
        User user3 = this.getModelFactory().makeUser();
        user3.setId(3);
        user3.setName("John");
        user3.setSurname("Brown");
        User user4 = this.getModelFactory().makeUser();
        user4.setId(4);
        user4.setName("Michael");
        user4.setSurname("Black");
        this.getCacheForWrite().put((Object)("user_" + user1.getId()), (Object)user1);
        this.getCacheForWrite().put((Object)("user_" + user2.getId()), (Object)user2);
        this.getCacheForWrite().put((Object)("user_" + user3.getId()), (Object)user3);
        this.getCacheForWrite().put((Object)("user_" + user4.getId()), (Object)user4);
    }

    public void testOrderByAsc() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).build();
        Assert.assertEquals((long)4L, (long)q.getResultSize());
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        this.checkNameOrder(list, true);
    }

    public void testOrderByDesc() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("surname", SortOrder.DESC).build();
        Assert.assertEquals((long)4L, (long)q.getResultSize());
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        this.checkSurnameOrder(list, false);
    }

    public void testMaxResults() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).maxResults(2).build();
        Assert.assertEquals((long)4L, (long)q.getResultSize());
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        this.checkNameOrder(list, true);
    }

    public void testStartOffset() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).startOffset(2L).build();
        Assert.assertEquals((long)4L, (long)q.getResultSize());
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        this.checkNameOrder(list, true);
    }

    public void testProjection1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"id", "name"}).maxResults(3).build();
        Assert.assertEquals((long)4L, (long)q.getResultSize());
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (Object[] u : list) {
            Assert.assertNotNull((Object)u[1]);
            Assert.assertTrue((boolean)(u[0] instanceof Integer));
        }
    }

    public void testIteration1() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator());
    }

    public void testIteration2() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(1)));
    }

    public void testIteration3() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(3)));
    }

    public void testIteration4() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER).fetchSize(1)));
    }

    public void testIteration5() throws Exception {
        LuceneQuery q = this.getIterationQuery();
        this.checkIterator(4, q.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER).fetchSize(3)));
    }

    private LuceneQuery getIterationQuery() {
        QueryFactory qf = this.getQueryFactory();
        QueryBuilder queryQueryBuilder = qf.from(this.getModelFactory().getUserImplClass()).not().having("surname").eq((Object)"Blue").toBuilder();
        return (LuceneQuery)queryQueryBuilder.build();
    }

    private void checkIterator(int expected, ResultIterator iterator) {
        int elements = 0;
        while (iterator.hasNext()) {
            User u = (User)iterator.next();
            Assert.assertNotNull((Object)u.getName());
            Assert.assertNotNull((Object)u.getSurname());
            ++elements;
        }
        Assert.assertEquals((long)expected, (long)elements);
    }

    private void checkNameOrder(List<User> list, boolean isAsc) {
        String prevName = null;
        for (User u : list) {
            Assert.assertNotNull((Object)u.getName());
            if (prevName != null) {
                int comp = u.getName().compareTo(prevName);
                Assert.assertTrue((boolean)(isAsc ? comp >= 0 : comp <= 0));
            }
            prevName = u.getName();
        }
    }

    private void checkSurnameOrder(List<User> list, boolean isAsc) {
        String prevSurname = null;
        for (User u : list) {
            Assert.assertNotNull((Object)u.getSurname());
            if (prevSurname != null) {
                int comp = u.getSurname().compareTo(prevSurname);
                Assert.assertTrue((boolean)(isAsc ? comp >= 0 : comp <= 0));
            }
            prevSurname = u.getSurname();
        }
    }
}

