/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.DelegatingCacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.filter.FilterIndexingServiceProvider;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.FilterResultImpl;
import org.infinispan.query.dsl.embedded.impl.JPACacheEventFilterConverter;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;

public class JPAFilterIndexingServiceProvider
implements FilterIndexingServiceProvider {
    private final ConcurrentMap<Matcher, FilteringListenerInvocation<?, ?>> filteringInvocations = new ConcurrentHashMap(2);
    private CacheNotifierImpl cacheNotifier;
    private ClusteringDependentLogic clusteringDependentLogic;

    @Inject
    protected void injectDependencies(CacheNotifier cacheNotifier, ClusteringDependentLogic clusteringDependentLogic) {
        this.cacheNotifier = (CacheNotifierImpl)cacheNotifier;
        this.clusteringDependentLogic = clusteringDependentLogic;
    }

    public void start() {
    }

    public void stop() {
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryActivated.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryCreated.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryInvalidated.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryLoaded.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryModified.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryPassivated.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryRemoved.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryVisited.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntriesEvicted.class).removeAll(this.filteringInvocations.values());
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryExpired.class).removeAll(this.filteringInvocations.values());
        this.filteringInvocations.clear();
    }

    public boolean supportsFilter(IndexedFilter<?, ?, ?> indexedFilter) {
        return indexedFilter.getClass() == JPACacheEventFilterConverter.class;
    }

    public <K, V> DelegatingCacheEntryListenerInvocation<K, V> interceptListenerInvocation(CacheEntryListenerInvocation<K, V> invocation) {
        return new DelegatingCacheEntryListenerInvocationImpl<K, V>(invocation);
    }

    public <K, V> void registerListenerInvocations(boolean isClustered, boolean isPrimaryOnly, boolean filterAndConvert, IndexedFilter<?, ?, ?> indexedFilter, Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners) {
        JPAFilterAndConverter filter = ((JPACacheEventFilterConverter)indexedFilter).filterAndConverter;
        Matcher matcher = filter.getMatcher();
        this.addFilteringInvocationForMatcher(matcher);
        Object[] eventTypes = new Event.Type[listeners.keySet().size()];
        int i = 0;
        for (Class<? extends Annotation> annotation : listeners.keySet()) {
            eventTypes[i++] = this.getEventType(annotation);
        }
        Callback<K, V> callback = new Callback<K, V>(matcher, isClustered, isPrimaryOnly, filterAndConvert, listeners);
        callback.subscription = matcher.registerFilter(filter.getJPAQuery(), callback, eventTypes);
    }

    private Event.Type getEventType(Class<? extends Annotation> annotation) {
        if (annotation == CacheEntryCreated.class) {
            return Event.Type.CACHE_ENTRY_CREATED;
        }
        if (annotation == CacheEntryModified.class) {
            return Event.Type.CACHE_ENTRY_MODIFIED;
        }
        if (annotation == CacheEntryRemoved.class) {
            return Event.Type.CACHE_ENTRY_REMOVED;
        }
        if (annotation == CacheEntryActivated.class) {
            return Event.Type.CACHE_ENTRY_ACTIVATED;
        }
        if (annotation == CacheEntryInvalidated.class) {
            return Event.Type.CACHE_ENTRY_INVALIDATED;
        }
        if (annotation == CacheEntryLoaded.class) {
            return Event.Type.CACHE_ENTRY_LOADED;
        }
        if (annotation == CacheEntryPassivated.class) {
            return Event.Type.CACHE_ENTRY_PASSIVATED;
        }
        if (annotation == CacheEntryVisited.class) {
            return Event.Type.CACHE_ENTRY_VISITED;
        }
        if (annotation == CacheEntriesEvicted.class) {
            return Event.Type.CACHE_ENTRY_EVICTED;
        }
        if (annotation == CacheEntryExpired.class) {
            return Event.Type.CACHE_ENTRY_EXPIRED;
        }
        return null;
    }

    private void addFilteringInvocationForMatcher(Matcher matcher) {
        FilteringListenerInvocation filteringInvocation;
        if (!this.filteringInvocations.containsKey(matcher) && this.filteringInvocations.putIfAbsent(matcher, filteringInvocation = new FilteringListenerInvocation(matcher)) == null) {
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryActivated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryCreated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryInvalidated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryLoaded.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryModified.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryPassivated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryRemoved.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryVisited.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntriesEvicted.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryExpired.class).add(filteringInvocation);
        }
    }

    protected Object makeFilterResult(Object instance, Object[] projection, Comparable[] sortProjection) {
        return new FilterResultImpl(instance, projection, sortProjection);
    }

    private class FilteringListenerInvocation<K, V>
    implements CacheEntryListenerInvocation<K, V> {
        private final Matcher matcher;

        private FilteringListenerInvocation(Matcher matcher) {
            this.matcher = matcher;
        }

        public Object getTarget() {
            return JPAFilterIndexingServiceProvider.this;
        }

        public void invoke(Event<K, V> event) {
        }

        public void invoke(CacheEntryEvent<K, V> event, boolean isLocalNodePrimaryOwner) {
            if (event.getValue() != null) {
                this.matcher.match(event, event.getValue(), (Object)event.getType());
            }
        }

        public void invokeNoChecks(CacheEntryEvent<K, V> event, boolean skipQueue, boolean skipConverter) {
        }

        public boolean isClustered() {
            return false;
        }

        public boolean isSync() {
            return true;
        }

        public UUID getIdentifier() {
            return null;
        }

        public Listener.Observation getObservation() {
            return Listener.Observation.BOTH;
        }

        public Class<? extends Annotation> getAnnotation() {
            return null;
        }

        public CacheEventFilter<? super K, ? super V> getFilter() {
            return null;
        }

        public <C> CacheEventConverter<? super K, ? super V, C> getConverter() {
            return null;
        }
    }

    private class DelegatingCacheEntryListenerInvocationImpl<K, V>
    extends DelegatingCacheEntryListenerInvocation<K, V> {
        protected Callback<K, V> callback;

        public DelegatingCacheEntryListenerInvocationImpl(CacheEntryListenerInvocation<K, V> invocation) {
            super(invocation);
        }

        public void unregister() {
            if (this.callback != null) {
                this.callback.unregister();
            }
        }
    }

    private class Callback<K, V>
    implements FilterCallback {
        private final boolean isClustered;
        private final boolean isPrimaryOnly;
        private final boolean filterAndConvert;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] activated_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] created_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] invalidated_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] loaded_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] modified_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] passivated_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] removed_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] visited_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] evicted_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] expired_invocations;
        private Matcher matcher;
        protected FilterSubscription subscription;

        Callback(Matcher matcher, boolean isClustered, boolean isPrimaryOnly, boolean filterAndConvert, Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners) {
            this.matcher = matcher;
            this.isClustered = isClustered;
            this.isPrimaryOnly = isPrimaryOnly;
            this.filterAndConvert = filterAndConvert;
            this.activated_invocations = this.makeArray(listeners, CacheEntryActivated.class);
            this.created_invocations = this.makeArray(listeners, CacheEntryCreated.class);
            this.invalidated_invocations = this.makeArray(listeners, CacheEntryInvalidated.class);
            this.loaded_invocations = this.makeArray(listeners, CacheEntryLoaded.class);
            this.modified_invocations = this.makeArray(listeners, CacheEntryModified.class);
            this.passivated_invocations = this.makeArray(listeners, CacheEntryPassivated.class);
            this.removed_invocations = this.makeArray(listeners, CacheEntryRemoved.class);
            this.visited_invocations = this.makeArray(listeners, CacheEntryVisited.class);
            this.evicted_invocations = this.makeArray(listeners, CacheEntriesEvicted.class);
            this.expired_invocations = this.makeArray(listeners, CacheEntryExpired.class);
        }

        private DelegatingCacheEntryListenerInvocation<K, V>[] makeArray(Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners, Class<? extends Annotation> eventType) {
            DelegatingCacheEntryListenerInvocation[] invocationsArray;
            List<DelegatingCacheEntryListenerInvocation<K, V>> invocations = listeners.get(eventType);
            if (invocations == null) {
                return null;
            }
            for (DelegatingCacheEntryListenerInvocation di : invocationsArray = invocations.toArray(new DelegatingCacheEntryListenerInvocation[invocations.size()])) {
                ((DelegatingCacheEntryListenerInvocationImpl)di).callback = this;
            }
            return invocationsArray;
        }

        private <T> T[] concatArrays(T[] first, T[] second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            T[] result = Arrays.copyOf(first, first.length + second.length);
            System.arraycopy(second, 0, result, first.length, second.length);
            return result;
        }

        void unregister() {
            if (this.subscription != null) {
                this.matcher.unregisterFilter(this.subscription);
                this.subscription = null;
            }
        }

        public void onFilterResult(Object userContext, Object instance, Object eventType, Object[] projection, Comparable[] sortProjection) {
            DelegatingCacheEntryListenerInvocation<K, V>[] invocations;
            switch ((Event.Type)eventType) {
                case CACHE_ENTRY_ACTIVATED: {
                    invocations = this.activated_invocations;
                    break;
                }
                case CACHE_ENTRY_CREATED: {
                    invocations = this.created_invocations;
                    break;
                }
                case CACHE_ENTRY_INVALIDATED: {
                    invocations = this.invalidated_invocations;
                    break;
                }
                case CACHE_ENTRY_LOADED: {
                    invocations = this.loaded_invocations;
                    break;
                }
                case CACHE_ENTRY_MODIFIED: {
                    invocations = this.modified_invocations;
                    break;
                }
                case CACHE_ENTRY_PASSIVATED: {
                    invocations = this.passivated_invocations;
                    break;
                }
                case CACHE_ENTRY_REMOVED: {
                    invocations = this.removed_invocations;
                    break;
                }
                case CACHE_ENTRY_VISITED: {
                    invocations = this.visited_invocations;
                    break;
                }
                case CACHE_ENTRY_EVICTED: {
                    invocations = this.evicted_invocations;
                    break;
                }
                case CACHE_ENTRY_EXPIRED: {
                    invocations = this.expired_invocations;
                    break;
                }
                default: {
                    return;
                }
            }
            if (invocations != null) {
                CacheEntryEvent event = (CacheEntryEvent)userContext;
                if (event.isPre() && this.isClustered || this.isPrimaryOnly && !JPAFilterIndexingServiceProvider.this.clusteringDependentLogic.localNodeIsPrimaryOwner(event.getKey())) {
                    return;
                }
                if (this.filterAndConvert && event instanceof EventImpl) {
                    EventImpl eventImpl = (EventImpl)event;
                    EventImpl clone = eventImpl.clone();
                    clone.setValue(JPAFilterIndexingServiceProvider.this.makeFilterResult(projection == null ? instance : null, projection, sortProjection));
                    event = clone;
                }
                for (DelegatingCacheEntryListenerInvocation<K, V> invocation : invocations) {
                    if (!invocation.getObservation().shouldInvoke(event.isPre())) continue;
                    invocation.invokeNoChecks(event, false, this.filterAndConvert);
                }
            }
        }
    }
}

