/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.continuous.CallCountingCQResultListener;
import org.infinispan.query.continuous.ContinuousQuery;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractCQMultipleCachesTest
extends MultipleCacheManagersTest {
    protected final int NUM_CACHES = 3;
    protected final int NUM_OWNERS = 2;

    protected abstract CacheMode getCacheMode();

    protected void createCacheManagers() {
        ConfigurationBuilder c = this.buildConfiguration();
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder c = AbstractCQMultipleCachesTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        c.clustering().hash().numOwners(2);
        return c;
    }

    protected CallCountingCQResultListener<Object, Object> createContinuousQuery() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache(0));
        Query query = qf.from(Person.class).having("age").lte((Object)30).toBuilder().build();
        CallCountingCQResultListener<Object, Object> listener = new CallCountingCQResultListener<Object, Object>();
        ContinuousQuery cq = new ContinuousQuery(this.cache(0));
        cq.addContinuousQueryListener(query, listener);
        return listener;
    }

    public void testContinuousQueryMultipleCaches() {
        Person value;
        int i;
        CallCountingCQResultListener<Object, Object> listener = this.createContinuousQuery();
        Map<Object, Integer> joined = listener.getJoined();
        Map<Object, Integer> left = listener.getLeft();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(40);
            this.cache(i).put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache(0).put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)6L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((long)1L, (long)joined.get(i).intValue());
        }
        joined.clear();
        this.cache(0).clear();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)6L, (long)left.size());
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((long)1L, (long)left.get(i).intValue());
        }
        left.clear();
    }

    public void testCQCacheLeavesAndJoins() {
        Person value;
        int i;
        CallCountingCQResultListener<Object, Object> listener = this.createContinuousQuery();
        Map<Object, Integer> joined = listener.getJoined();
        Map<Object, Integer> left = listener.getLeft();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(40);
            this.cache(i).put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache(0).put((Object)i, (Object)value);
            if (i != 4) continue;
            this.killMember(1);
        }
        Assert.assertEquals((long)6L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((long)1L, (long)joined.get(i).intValue());
        }
        joined.clear();
        this.cache(0).clear();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)6L, (long)left.size());
        left.clear();
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache(0).put((Object)i, (Object)value);
            if (i != 4) continue;
            this.addClusterEnabledCacheManager(this.buildConfiguration());
        }
        Assert.assertEquals((long)6L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((long)1L, (long)joined.get(i).intValue());
        }
        joined.clear();
    }
}

