/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.continuous.CallCountingCQResultListener;
import org.infinispan.query.continuous.ContinuousQuery;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.continuous.ContinuousQueryTest")
public class ContinuousQueryTest
extends SingleCacheManagerTest {
    protected ControlledTimeService timeService = new ControlledTimeService(0L);

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cacheConfiguration = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cacheConfiguration);
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true);
        return cm;
    }

    public void testContinuousQuery() {
        Person value;
        int i;
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        ContinuousQuery cq = new ContinuousQuery(this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)30).toBuilder().build();
        CallCountingCQResultListener listener = new CallCountingCQResultListener();
        cq.addContinuousQueryListener(query, listener);
        Map joined = listener.getJoined();
        Map left = listener.getLeft();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(40);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)6L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        joined.clear();
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 40);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)left.size());
        left.clear();
        for (i = 4; i < 20; ++i) {
            this.cache().remove((Object)i);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)left.size());
        left.clear();
        this.cache().clear();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)left.size());
        left.clear();
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 20);
            this.cache().put((Object)i, (Object)value, 5L, TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((long)2L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        joined.clear();
        this.timeService.advance(6L);
        this.cache.getAdvancedCache().getExpirationManager().processExpiration();
        Assert.assertEquals((long)0L, (long)this.cache().size());
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)left.size());
        left.clear();
        cq.removeContinuousQueryListener(listener);
        for (i = 0; i < 3; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 20);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
    }

    public void testTwoSimilarCQ() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        CallCountingCQResultListener listener = new CallCountingCQResultListener();
        Query query1 = qf.from(Person.class).having("age").lte((Object)30).and().having("name").eq((Object)"John").or().having("name").eq((Object)"Johny").toBuilder().build();
        ContinuousQuery cq1 = new ContinuousQuery(this.cache());
        cq1.addContinuousQueryListener(query1, listener);
        Query query2 = qf.from(Person.class).having("age").lte((Object)30).or().having("name").eq((Object)"Joe").toBuilder().build();
        ContinuousQuery cq2 = new ContinuousQuery(this.cache());
        cq2.addContinuousQueryListener(query2, listener);
        Map joined = listener.getJoined();
        Map left = listener.getLeft();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        Person value = new Person();
        value.setName("John");
        value.setAge(20);
        this.cache().put((Object)1, (Object)value);
        Assert.assertEquals((long)1L, (long)joined.size());
        Assert.assertEquals((long)2L, (long)joined.get(1).intValue());
        Assert.assertEquals((long)0L, (long)left.size());
        joined.clear();
        value = new Person();
        value.setName("Joe");
        this.cache().replace((Object)1, (Object)value);
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)1L, (long)left.size());
        joined.clear();
        left.clear();
        value = new Person();
        value.setName("Joe");
        value.setAge(31);
        this.cache().replace((Object)1, (Object)value);
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        joined.clear();
        left.clear();
        value = new Person();
        value.setName("John");
        value.setAge(29);
        this.cache().put((Object)1, (Object)value);
        Assert.assertEquals((long)1L, (long)joined.size());
        Assert.assertEquals((long)1L, (long)joined.get(1).intValue());
        Assert.assertEquals((long)0L, (long)left.size());
        joined.clear();
        left.clear();
        value = new Person();
        value.setName("Johny");
        value.setAge(29);
        this.cache().put((Object)1, (Object)value);
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)0L, (long)left.size());
        joined.clear();
        left.clear();
        this.cache().clear();
        Assert.assertEquals((long)0L, (long)joined.size());
        Assert.assertEquals((long)1L, (long)left.size());
        Assert.assertEquals((long)2L, (long)left.get(1).intValue());
    }
}

