/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.LocalCacheMassIndexerTest")
public class LocalCacheMassIndexerTest
extends SingleCacheManagerTest {
    private static final int NUM_ENTITIES = 2000;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    private int indexSize(Cache<?, ?> cache) {
        SearchManager searchManager = Search.getSearchManager(cache);
        return searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Person.class}).getResultSize();
    }

    @Test
    public void testMassIndexer() {
        for (int i = 0; i < 2000; ++i) {
            this.cache.put((Object)i, (Object)new Person("name" + i, "blurb" + i, i));
        }
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        AssertJUnit.assertEquals((int)2000, (int)this.indexSize(this.cache));
        searchManager.getMassIndexer().start();
        AssertJUnit.assertEquals((int)2000, (int)this.indexSize(this.cache));
        this.cache.clear();
        searchManager.getMassIndexer().start();
        AssertJUnit.assertEquals((int)0, (int)this.indexSize(this.cache));
    }
}

