/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.ListenerWithDslFilterTest")
public class ListenerWithDslFilterTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)this.getConfigurationBuilder());
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return cfgBuilder;
    }

    public void testEventFilter() {
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(99);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)10L, (long)this.cache.size());
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)31).toBuilder().build();
        EntryListener listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        Assert.assertTrue((boolean)listener.createEvents.isEmpty());
        Assert.assertTrue((boolean)listener.modifyEvents.isEmpty());
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)10L, (long)this.cache.size());
        Assert.assertTrue((boolean)listener.createEvents.isEmpty());
        Assert.assertEquals((long)7L, (long)listener.modifyEvents.size());
        for (ObjectFilter.FilterResult r : listener.modifyEvents) {
            Person p = (Person)r.getInstance();
            Assert.assertTrue((p.getAge() <= 31 ? 1 : 0) != 0);
        }
        this.cache().removeListener((Object)listener);
        listener.createEvents.clear();
        listener.modifyEvents.clear();
        Person value = new Person();
        value.setName("George");
        value.setAge(30);
        this.cache().put((Object)-1, (Object)value);
        Assert.assertTrue((boolean)listener.createEvents.isEmpty());
        Assert.assertTrue((boolean)listener.modifyEvents.isEmpty());
    }

    public void testEventFilterAndConverter() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        Query query = qf.from(Person.class).having("age").lte((Object)31).toBuilder().select(new String[]{"name", "age"}).build();
        EntryListener listener = new EntryListener();
        this.cache().addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache.put((Object)i, (Object)value);
        }
        Assert.assertEquals((long)10L, (long)this.cache.size());
        Assert.assertEquals((long)7L, (long)listener.createEvents.size());
        Assert.assertTrue((boolean)listener.modifyEvents.isEmpty());
        for (ObjectFilter.FilterResult r : listener.createEvents) {
            Assert.assertNotNull((Object)r.getProjection());
            Assert.assertEquals((long)2L, (long)r.getProjection().length);
            Assert.assertTrue(((Integer)r.getProjection()[1] <= 31 ? 1 : 0) != 0);
        }
        this.cache().removeListener((Object)listener);
    }

    @Listener(includeCurrentState=true, observation=Listener.Observation.POST)
    public static class EntryListener {
        public final List<ObjectFilter.FilterResult> createEvents = new ArrayList<ObjectFilter.FilterResult>();
        public final List<ObjectFilter.FilterResult> modifyEvents = new ArrayList<ObjectFilter.FilterResult>();

        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent<?, ObjectFilter.FilterResult> event) {
            ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
            this.createEvents.add(filterResult);
        }

        @CacheEntryModified
        public void handleEvent(CacheEntryModifiedEvent<?, ObjectFilter.FilterResult> event) {
            ObjectFilter.FilterResult filterResult = (ObjectFilter.FilterResult)event.getValue();
            this.modifyEvents.add(filterResult);
        }
    }
}

