/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexedembedded;

import java.util.List;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.indexedembedded.City;
import org.infinispan.query.indexedembedded.Country;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.indexedembedded.CollectionsIndexingTest")
public class CollectionsIndexingTest
extends SingleCacheManagerTest {
    private SearchManager qf;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @BeforeClass
    public void prepareSearchFactory() throws Exception {
        this.qf = Search.getSearchManager((Cache)this.cache);
    }

    @AfterMethod
    public void cleanupData() {
        this.cache.clear();
    }

    @Test
    public void searchOnEmptyIndex() throws ParseException {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");
        Query query = queryParser.parse("Italy");
        List list = this.qf.getQuery(query, new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void searchOnAllTypes() throws ParseException {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");
        Query query = queryParser.parse("Italy");
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        List list = this.qf.getQuery(query, new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.qf.getQuery(query, new Class[0]).list();
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.qf.getQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void searchOnSimpleField() throws ParseException {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");
        Query query = queryParser.parse("Italy");
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        List list = this.qf.getQuery(query, new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void searchOnEmbeddedField() throws ParseException {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("cities.name");
        Query query = queryParser.parse("Newcastle");
        Country uk = new Country();
        City london = new City();
        london.name = "London";
        City newcastle = new City();
        newcastle.name = "Newcastle";
        uk.countryName = "United Kingdom";
        uk.cities.add(newcastle);
        uk.cities.add(london);
        this.cache.put((Object)"UK", (Object)uk);
        this.cache.put((Object)"UK", (Object)uk);
        this.cache.put((Object)"UK", (Object)uk);
        List list = this.qf.getQuery(query, new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((uk == list.get(0) ? 1 : 0) != 0);
    }
}

