/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.Serializable;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.config.XMLConfigurationOverridingTest")
public class XMLConfigurationOverridingTest
extends AbstractInfinispanTest {
    private static final String simpleCacheName = "simpleLocalCache";

    public void testOverrideIndexing() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configs/named-cache-override-test.xml")){

            public void call() {
                Configuration cnf = this.cm.getCacheConfiguration(XMLConfigurationOverridingTest.simpleCacheName);
                Assert.assertFalse((boolean)cnf.indexing().index().isEnabled());
                Configuration conf = new ConfigurationBuilder().indexing().index(Index.NONE).addProperty("default.directory_provider", "infinispan").build();
                this.cm.defineConfiguration(XMLConfigurationOverridingTest.simpleCacheName, conf);
                cnf = this.cm.getCacheConfiguration(XMLConfigurationOverridingTest.simpleCacheName);
                Assert.assertFalse((boolean)cnf.indexing().index().isEnabled());
                Assert.assertFalse((boolean)cnf.indexing().index().isLocalOnly());
                Assert.assertEquals((Object)"infinispan", (Object)cnf.indexing().properties().getProperty("default.directory_provider"));
                Assert.assertFalse((boolean)this.cm.getCacheNames().contains("LuceneIndexesMetadata"));
                this.cm.getCache(XMLConfigurationOverridingTest.simpleCacheName).put((Object)"key0", (Object)new NonIndexedClass("value0"));
                Assert.assertFalse((boolean)this.cm.getCacheNames().contains("LuceneIndexesMetadata"));
            }
        });
    }

    class NonIndexedClass
    implements Serializable {
        public String description;

        NonIndexedClass(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonIndexedClass that = (NonIndexedClass)o;
            return this.description.equals(that.description);
        }

        public int hashCode() {
            return this.description.hashCode();
        }
    }
}

