/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.ExtendedSearchWorkCreator;
import org.infinispan.query.backend.IndexModificationStrategy;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.ReadIntensiveClusterRegistryWrapper;
import org.infinispan.query.backend.SearchFactoryHandler;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.backend.SearchWorkCreatorContext;
import org.infinispan.query.backend.TransactionHelper;
import org.infinispan.query.backend.TransactionalEventTransactionContext;
import org.infinispan.query.impl.DefaultSearchWorkCreator;
import org.infinispan.query.logging.Log;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.registry.ScopedKey;
import org.infinispan.util.logging.LogFactory;

public final class QueryInterceptor
extends CommandInterceptor {
    private final IndexModificationStrategy indexingMode;
    private final SearchIntegrator searchFactory;
    private final KeyTransformationHandler keyTransformationHandler = new KeyTransformationHandler();
    private final KnownClassesRegistryListener registryListener = new KnownClassesRegistryListener();
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private ReadIntensiveClusterRegistryWrapper<String, Class<?>, Boolean> clusterRegistry;
    private SearchWorkCreator<Object> searchWorkCreator = new DefaultSearchWorkCreator<Object>();
    private SearchFactoryHandler searchFactoryHandler;
    private DataContainer dataContainer;
    protected TransactionManager transactionManager;
    protected TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    protected ExecutorService asyncExecutor;
    private static final Log log = (Log)LogFactory.getLog(QueryInterceptor.class, Log.class);

    protected Log getLog() {
        return log;
    }

    public QueryInterceptor(SearchIntegrator searchFactory, IndexModificationStrategy indexingMode) {
        this.searchFactory = searchFactory;
        this.indexingMode = indexingMode;
    }

    @Inject
    protected void injectDependencies(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, Cache cache, ClusterRegistry<String, Class<?>, Boolean> clusterRegistry, DataContainer dataContainer, @ComponentName(value="org.infinispan.executors.transport") ExecutorService e) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.asyncExecutor = e;
        this.dataContainer = dataContainer;
        this.clusterRegistry = new ReadIntensiveClusterRegistryWrapper(clusterRegistry, "QueryKnownClasses#" + cache.getName());
        this.searchFactoryHandler = new SearchFactoryHandler(this.searchFactory, this.clusterRegistry, new TransactionHelper(transactionManager));
    }

    @Start
    protected void start() {
        this.clusterRegistry.addListener(this.registryListener);
        Set<Class<?>> keys = this.clusterRegistry.keys();
        Class[] array = keys.toArray(new Class[keys.size()]);
        this.enableClasses(array);
        this.stopping.set(false);
    }

    @Stop
    protected void stop() {
        this.clusterRegistry.removeListener(this.registryListener);
    }

    public void prepareForStopping() {
        this.stopping.set(true);
    }

    protected boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx) {
        return this.indexingMode.shouldModifyIndexes(command, ctx);
    }

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object toReturn = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processPutKeyValueCommand(command, ctx, toReturn, null);
        return toReturn;
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object valueRemoved = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processRemoveCommand(command, ctx, valueRemoved, null);
        return valueRemoved;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object valueReplaced = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processReplaceCommand(command, ctx, valueReplaced, null);
        return valueReplaced;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Map previousValues = (Map)this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processPutMapCommand(command, ctx, previousValues, null);
        return previousValues;
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processClearCommand(command, ctx, null);
        return returnValue;
    }

    public void purgeAllIndexes() {
        this.purgeAllIndexes(null);
    }

    public void purgeIndex(Class<?> entityType) {
        this.purgeIndex(null, entityType);
    }

    private void purgeIndex(TransactionContext transactionContext, Class<?> entityType) {
        transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
        Boolean isIndexable = this.clusterRegistry.get(entityType);
        if (isIndexable != null && isIndexable.booleanValue() && this.searchFactoryHandler.isIndexed(entityType)) {
            this.performSearchWorks(this.searchWorkCreator.createPerEntityTypeWorks(entityType, WorkType.PURGE_ALL), transactionContext);
        }
    }

    private void purgeAllIndexes(TransactionContext transactionContext) {
        transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
        for (Class<?> c : this.clusterRegistry.keys()) {
            if (!this.searchFactoryHandler.isIndexed(c)) continue;
            this.performSearchWorks(this.searchWorkCreator.createPerEntityTypeWorks(c, WorkType.PURGE_ALL), transactionContext);
        }
    }

    protected void removeFromIndexes(Object value, Object key, TransactionContext transactionContext) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key)), WorkType.DELETE, transactionContext);
    }

    protected void updateIndexes(boolean usingSkipIndexCleanupFlag, Object value, Object key, TransactionContext transactionContext) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key)), usingSkipIndexCleanupFlag ? WorkType.ADD : WorkType.UPDATE, transactionContext);
    }

    private void performSearchWork(Object value, Serializable id, WorkType workType, TransactionContext transactionContext) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        Collection<Work> works = this.searchWorkCreator.createPerEntityWorks(value, id, workType);
        this.performSearchWorks(works, transactionContext);
    }

    private void performSearchWorks(Collection<Work> works, TransactionContext transactionContext) {
        Worker worker = this.searchFactory.getWorker();
        for (Work work : works) {
            worker.performWork(work, transactionContext);
        }
    }

    public boolean isIndexed(Class<?> c) {
        return this.searchFactoryHandler.isIndexed(c);
    }

    private Object extractValue(Object wrappedValue) {
        if (wrappedValue instanceof MarshalledValue) {
            return ((MarshalledValue)wrappedValue).get();
        }
        return wrappedValue;
    }

    public void enableClasses(Class[] classes) {
        this.searchFactoryHandler.enableClasses(classes);
    }

    public boolean updateKnownTypesIfNeeded(Object value) {
        return this.searchFactoryHandler.updateKnownTypesIfNeeded(value);
    }

    public void registerKeyTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.keyTransformationHandler.registerTransformer(keyClass, transformerClass);
    }

    private String keyToString(Object key) {
        return this.keyTransformationHandler.keyToString(key);
    }

    public KeyTransformationHandler getKeyTransformationHandler() {
        return this.keyTransformationHandler;
    }

    public SearchIntegrator getSearchFactory() {
        return this.searchFactory;
    }

    public void setSearchWorkCreator(SearchWorkCreator<Object> searchWorkCreator) {
        this.searchWorkCreator = searchWorkCreator;
    }

    public SearchWorkCreator<Object> getSearchWorkCreator() {
        return this.searchWorkCreator;
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        WriteCommand[] writeCommands = command.getModifications();
        Object[] stateBeforePrepare = new Object[writeCommands.length];
        for (int i = 0; i < writeCommands.length; ++i) {
            InternalCacheEntry internalCacheEntry;
            WriteCommand writeCommand = writeCommands[i];
            if (writeCommand instanceof PutKeyValueCommand) {
                internalCacheEntry = this.dataContainer.get(((PutKeyValueCommand)writeCommand).getKey());
                stateBeforePrepare[i] = internalCacheEntry != null ? internalCacheEntry.getValue() : null;
                continue;
            }
            if (writeCommand instanceof PutMapCommand) {
                stateBeforePrepare[i] = this.getPreviousValues(((PutMapCommand)writeCommand).getMap().keySet());
                continue;
            }
            if (writeCommand instanceof RemoveCommand) {
                internalCacheEntry = this.dataContainer.get(((RemoveCommand)writeCommand).getKey());
                stateBeforePrepare[i] = internalCacheEntry != null ? internalCacheEntry.getValue() : null;
                continue;
            }
            if (!(writeCommand instanceof ReplaceCommand)) continue;
            internalCacheEntry = this.dataContainer.get(((ReplaceCommand)writeCommand).getKey());
            stateBeforePrepare[i] = internalCacheEntry != null ? internalCacheEntry.getValue() : null;
        }
        Object toReturn = super.visitPrepareCommand(ctx, command);
        if (ctx.isTransactionValid()) {
            TransactionContext transactionContext = this.makeTransactionalEventContext();
            for (int i = 0; i < writeCommands.length; ++i) {
                WriteCommand writeCommand = writeCommands[i];
                if (writeCommand instanceof PutKeyValueCommand) {
                    this.processPutKeyValueCommand((PutKeyValueCommand)writeCommand, (InvocationContext)ctx, stateBeforePrepare[i], transactionContext);
                    continue;
                }
                if (writeCommand instanceof PutMapCommand) {
                    this.processPutMapCommand((PutMapCommand)writeCommand, (InvocationContext)ctx, (Map)stateBeforePrepare[i], transactionContext);
                    continue;
                }
                if (writeCommand instanceof RemoveCommand) {
                    this.processRemoveCommand((RemoveCommand)writeCommand, (InvocationContext)ctx, stateBeforePrepare[i], transactionContext);
                    continue;
                }
                if (writeCommand instanceof ReplaceCommand) {
                    this.processReplaceCommand((ReplaceCommand)writeCommand, (InvocationContext)ctx, stateBeforePrepare[i], transactionContext);
                    continue;
                }
                if (!(writeCommand instanceof ClearCommand)) continue;
                this.processClearCommand((ClearCommand)writeCommand, (InvocationContext)ctx, transactionContext);
            }
        }
        return toReturn;
    }

    private Map<Object, Object> getPreviousValues(Set<Object> keySet) {
        HashMap<Object, Object> previousValues = new HashMap<Object, Object>();
        for (Object key : keySet) {
            InternalCacheEntry internalCacheEntry = this.dataContainer.get(key);
            Object previousValue = internalCacheEntry != null ? internalCacheEntry.getValue() : null;
            previousValues.put(key, previousValue);
        }
        return previousValues;
    }

    private void processReplaceCommand(ReplaceCommand command, InvocationContext ctx, Object valueReplaced, TransactionContext transactionContext) {
        if (valueReplaced != null && command.isSuccessful() && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            boolean usingSkipIndexCleanupFlag = this.usingSkipIndexCleanup((LocalFlagAffectedCommand)command);
            Object[] parameters = command.getParameters();
            Object p2 = this.extractValue(parameters[2]);
            boolean newValueIsIndexed = this.updateKnownTypesIfNeeded(p2);
            Object key = this.extractValue(command.getKey());
            if (!usingSkipIndexCleanupFlag) {
                Object p1 = this.extractValue(parameters[1]);
                boolean originalIsIndexed = this.updateKnownTypesIfNeeded(p1);
                if (p1 != null && originalIsIndexed) {
                    transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
                    this.removeFromIndexes(p1, key, transactionContext);
                }
            }
            if (newValueIsIndexed) {
                transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
                this.updateIndexes(usingSkipIndexCleanupFlag, p2, key, transactionContext);
            }
        }
    }

    private void processRemoveCommand(RemoveCommand command, InvocationContext ctx, Object valueRemoved, TransactionContext transactionContext) {
        Object value;
        if (command.isSuccessful() && !command.isNonExistent() && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx) && this.updateKnownTypesIfNeeded(value = this.extractValue(valueRemoved))) {
            transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
            this.removeFromIndexes(value, this.extractValue(command.getKey()), transactionContext);
        }
    }

    private void processPutMapCommand(PutMapCommand command, InvocationContext ctx, Map<Object, Object> previousValues, TransactionContext transactionContext) {
        if (this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            Map dataMap = command.getMap();
            boolean usingSkipIndexCleanupFlag = this.usingSkipIndexCleanup((LocalFlagAffectedCommand)command);
            for (Map.Entry entry : dataMap.entrySet()) {
                Object key = this.extractValue(entry.getKey());
                Object value = this.extractValue(entry.getValue());
                Object previousValue = previousValues.get(key);
                if (!usingSkipIndexCleanupFlag && this.updateKnownTypesIfNeeded(previousValue)) {
                    transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
                    this.removeFromIndexes(previousValue, key, transactionContext);
                }
                if (!this.updateKnownTypesIfNeeded(value)) continue;
                transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
                this.updateIndexes(usingSkipIndexCleanupFlag, value, key, transactionContext);
            }
        }
    }

    private void processPutKeyValueCommand(PutKeyValueCommand command, InvocationContext ctx, Object previousValue, TransactionContext transactionContext) {
        boolean usingSkipIndexCleanupFlag = this.usingSkipIndexCleanup((LocalFlagAffectedCommand)command);
        Object value = this.extractValue(command.getValue());
        if (!usingSkipIndexCleanupFlag && this.updateKnownTypesIfNeeded(previousValue) && this.shouldRemove(value, previousValue) && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
            this.removeFromIndexes(previousValue, this.extractValue(command.getKey()), transactionContext);
        }
        if (this.updateKnownTypesIfNeeded(value) && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
            this.updateIndexes(usingSkipIndexCleanupFlag, value, this.extractValue(command.getKey()), transactionContext);
        }
    }

    private boolean shouldRemove(Object value, Object previousValue) {
        if (this.getSearchWorkCreator() instanceof ExtendedSearchWorkCreator) {
            ExtendedSearchWorkCreator eswc = (ExtendedSearchWorkCreator)ExtendedSearchWorkCreator.class.cast(this.getSearchWorkCreator());
            return eswc.shouldRemove(new SearchWorkCreatorContext(previousValue, value));
        }
        return value != null && previousValue != null && !value.getClass().equals(previousValue.getClass());
    }

    private void processClearCommand(ClearCommand command, InvocationContext ctx, TransactionContext transactionContext) {
        if (this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            this.purgeAllIndexes(transactionContext);
        }
    }

    private TransactionContext makeTransactionalEventContext() {
        return new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry);
    }

    private boolean usingSkipIndexCleanup(LocalFlagAffectedCommand command) {
        return command != null && command.hasFlag(Flag.SKIP_INDEX_CLEANUP);
    }

    public IndexModificationStrategy getIndexModificationMode() {
        return this.indexingMode;
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    @Listener
    class KnownClassesRegistryListener {
        KnownClassesRegistryListener() {
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<ScopedKey<String, Class>, Boolean> e) {
            if (!e.isOriginLocal() && !e.isPre() && ((Boolean)e.getValue()).booleanValue()) {
                QueryInterceptor.this.searchFactoryHandler.handleClusterRegistryRegistration((Class)((ScopedKey)e.getKey()).getKey());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<ScopedKey<String, Class>, Boolean> e) {
            if (!e.isOriginLocal() && !e.isPre() && ((Boolean)e.getValue()).booleanValue()) {
                QueryInterceptor.this.searchFactoryHandler.handleClusterRegistryRegistration((Class)((ScopedKey)e.getKey()).getKey());
            }
        }
    }
}

