/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.hibernate.hql.ParsingException;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.builder.ClassBasedLucenePropertyHelper;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.objectfilter.impl.RowMatcher;
import org.infinispan.objectfilter.impl.aggregation.AvgAccumulator;
import org.infinispan.objectfilter.impl.aggregation.CountAccumulator;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MaxAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MinAccumulator;
import org.infinispan.objectfilter.impl.aggregation.SumAccumulator;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.hql.RowPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.JPATreePrinter;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.AggregatingQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.EmptyResultQuery;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchIndexedFieldProvider;
import org.infinispan.query.dsl.embedded.impl.HybridQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.embedded.impl.SecurityActions;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.util.KeyValuePair;

public class QueryEngine {
    private static final int MAX_EXPANSION_COFACTORS = 16;
    protected final AdvancedCache<?, ?> cache;
    protected final QueryCache queryCache;
    protected final SearchManager searchManager;
    protected final SearchIntegrator searchFactory;
    protected final QueryParser queryParser = new QueryParser();
    protected final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();

    public QueryEngine(AdvancedCache<?, ?> cache, SearchManager searchManager) {
        this.cache = cache;
        this.queryCache = ComponentRegistryUtils.getQueryCache(cache);
        this.searchManager = searchManager;
        this.searchFactory = searchManager != null ? searchManager.unwrap(SearchIntegrator.class) : null;
    }

    public BaseQuery buildQuery(QueryFactory queryFactory, String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults) {
        this.checkParameters(namedParameters);
        FilterParsingResult<?> parsingResult = this.parse(jpqlString, namedParameters);
        if (parsingResult.hasGroupingOrAggregations()) {
            return this.buildQueryWithAggregations(queryFactory, jpqlString, namedParameters, startOffset, maxResults, parsingResult);
        }
        return this.buildQueryNoAggregations(queryFactory, jpqlString, namedParameters, startOffset, maxResults, parsingResult);
    }

    private void checkParameters(Map<String, Object> namedParameters) {
        if (namedParameters != null) {
            for (Map.Entry<String, Object> e : namedParameters.entrySet()) {
                if (e.getValue() != null) continue;
                throw new IllegalStateException("Query parameter '" + e.getKey() + "' was not set");
            }
        }
    }

    private BaseQuery buildQueryWithAggregations(QueryFactory queryFactory, String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults, FilterParsingResult<?> parsingResult) {
        RowPropertyHelper.ColumnMetadata c;
        if (parsingResult.getProjectedPaths() == null) {
            throw new ParsingException("Queries containing grouping and aggregation functions must use projections.");
        }
        LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns = new LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata>();
        ObjectPropertyHelper propertyHelper = this.getFirstPhaseMatcher().getPropertyHelper();
        LinkedHashSet<Integer> groupFieldPositions = new LinkedHashSet<Integer>();
        if (parsingResult.getGroupBy() != null) {
            for (PropertyPath p : parsingResult.getGroupBy()) {
                if (columns.containsKey(p)) continue;
                Class propertyType = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
                int idx = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
                groupFieldPositions.add(idx);
            }
        }
        for (PropertyPath p : parsingResult.getProjectedPaths()) {
            RowPropertyHelper.ColumnMetadata c2 = (RowPropertyHelper.ColumnMetadata)columns.get(p);
            if (!(p.getAggregationType() != null || c2 != null && groupFieldPositions.contains(c2.getColumnIndex()))) {
                throw new ParsingException("The expression '" + p + "' must be part of an aggregate function or it should be included in the GROUP BY clause");
            }
            if (c2 != null) continue;
            Class propertyType = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
            int idx = columns.size();
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath p = sortField.getPath();
                RowPropertyHelper.ColumnMetadata c3 = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (!(p.getAggregationType() != null || c3 != null && groupFieldPositions.contains(c3.getColumnIndex()))) {
                    throw new ParsingException("The expression '" + p + "' must be part of an aggregate function or it should be included in the GROUP BY clause");
                }
                if (c3 != null) continue;
                Class propertyType = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
                int n = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(n, "C" + n, propertyType));
            }
        }
        String havingClause = null;
        if (parsingResult.getHavingClause() != null) {
            BooleanExpr normalizedHavingClause = this.booleanFilterNormalizer.normalize(parsingResult.getHavingClause());
            if (normalizedHavingClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, jpqlString, namedParameters, startOffset, maxResults);
            }
            if (normalizedHavingClause != ConstantBooleanExpr.TRUE) {
                havingClause = JPATreePrinter.printTree((BooleanExpr)this.swapVariables(normalizedHavingClause, parsingResult.getTargetEntityName(), columns));
            }
        }
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("SELECT ");
        boolean isFirst = true;
        for (PropertyPath[] c2 : columns.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                firstPhaseQuery.append(", ");
            }
            firstPhaseQuery.append("_gen0").append('.').append(c2.asStringPath());
        }
        firstPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = this.booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, jpqlString, namedParameters, startOffset, maxResults);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(JPATreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        boolean isFirst2 = true;
        for (PropertyPath propertyPath : parsingResult.getProjectedPaths()) {
            if (isFirst2) {
                isFirst2 = false;
            } else {
                secondPhaseQuery.append(", ");
            }
            c = columns.get(propertyPath);
            secondPhaseQuery.append(c.getColumnName());
        }
        secondPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            secondPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            secondPhaseQuery.append(" ORDER BY ");
            boolean isFirst3 = true;
            for (PropertyPath propertyPath : parsingResult.getSortFields()) {
                if (isFirst3) {
                    isFirst3 = false;
                } else {
                    secondPhaseQuery.append(", ");
                }
                c = columns.get(propertyPath.getPath());
                secondPhaseQuery.append(c.getColumnName()).append(' ').append(propertyPath.isAscending() ? "ASC" : "DESC");
            }
        }
        LinkedList<Object> accumulators = new LinkedList<Object>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        block13: for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata columnMetadata;
            _columns[columnMetadata.getColumnIndex()] = columnMetadata = columns.get(p);
            if (p.getAggregationType() != null) {
                switch (p.getAggregationType()) {
                    case SUM: {
                        accumulators.add(new SumAccumulator(columnMetadata.getColumnIndex(), columnMetadata.getPropertyType()));
                        continue block13;
                    }
                    case AVG: {
                        accumulators.add(new AvgAccumulator(columnMetadata.getColumnIndex(), columnMetadata.getPropertyType()));
                        continue block13;
                    }
                    case MIN: {
                        accumulators.add(new MinAccumulator(columnMetadata.getColumnIndex(), columnMetadata.getPropertyType()));
                        continue block13;
                    }
                    case MAX: {
                        accumulators.add(new MaxAccumulator(columnMetadata.getColumnIndex(), columnMetadata.getPropertyType()));
                        continue block13;
                    }
                    case COUNT: {
                        accumulators.add(new CountAccumulator(columnMetadata.getColumnIndex()));
                        continue block13;
                    }
                }
                throw new IllegalStateException("Aggregation " + p.getAggregationType().name() + " is not supported");
            }
            groupFieldPositions.add(columnMetadata.getColumnIndex());
        }
        int[] _groupFieldPositions = new int[groupFieldPositions.size()];
        int i = 0;
        for (Integer pos : groupFieldPositions) {
            _groupFieldPositions[i++] = pos;
        }
        FieldAccumulator[] fieldAccumulatorArray = accumulators.toArray(new FieldAccumulator[accumulators.size()]);
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, namedParameters, -1L, -1, this.parse(firstPhaseQueryStr, namedParameters));
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, secondPhaseQueryStr, namedParameters, _groupFieldPositions, fieldAccumulatorArray, this.getObjectFilter((BaseMatcher)new RowMatcher(_columns), secondPhaseQueryStr, namedParameters), startOffset, maxResults, (Query)baseQuery);
    }

    private BooleanExpr swapVariables(BooleanExpr expr, final String targetEntityName, final LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns) {
        final ObjectPropertyHelper propertyHelper = this.getFirstPhaseMatcher().getPropertyHelper();
        class PropertyReplacer
        implements Visitor {
            PropertyReplacer() {
            }

            public BooleanExpr visit(NotExpr notExpr) {
                return new NotExpr((BooleanExpr)notExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(OrExpr orExpr) {
                ArrayList<Object> visitedChildren = new ArrayList<Object>();
                for (BooleanExpr c : orExpr.getChildren()) {
                    visitedChildren.add(c.acceptVisitor((Visitor)this));
                }
                return new OrExpr(visitedChildren);
            }

            public BooleanExpr visit(AndExpr andExpr) {
                ArrayList<Object> visitedChildren = new ArrayList<Object>();
                for (BooleanExpr c : andExpr.getChildren()) {
                    visitedChildren.add(c.acceptVisitor((Visitor)this));
                }
                return new AndExpr(visitedChildren);
            }

            public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
                return constantBooleanExpr;
            }

            public BooleanExpr visit(IsNullExpr isNullExpr) {
                return new IsNullExpr((ValueExpr)isNullExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(ComparisonExpr comparisonExpr) {
                return new ComparisonExpr((ValueExpr)comparisonExpr.getLeftChild().acceptVisitor((Visitor)this), comparisonExpr.getRightChild(), comparisonExpr.getComparisonType());
            }

            public BooleanExpr visit(LikeExpr likeExpr) {
                return new LikeExpr((ValueExpr)likeExpr.getChild().acceptVisitor((Visitor)this), likeExpr.getPattern());
            }

            public ValueExpr visit(ConstantValueExpr constantValueExpr) {
                return constantValueExpr;
            }

            public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
                PropertyPath p = new PropertyPath(null, propertyValueExpr.getPropertyPath());
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (c == null) {
                    throw new ParsingException("The expression '" + propertyValueExpr.toJpaString() + "' must be part of an aggregate function or it should be included in the GROUP BY clause");
                }
                return new PropertyValueExpr(c.getColumnName(), propertyValueExpr.isRepeated());
            }

            public ValueExpr visit(AggregationExpr aggregationExpr) {
                PropertyPath p = new PropertyPath(aggregationExpr.getAggregationType(), aggregationExpr.getPropertyPath());
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (c == null) {
                    Class propertyType = propertyHelper.getPrimitivePropertyType(targetEntityName, aggregationExpr.getPropertyPath());
                    if (aggregationExpr.getAggregationType() == PropertyPath.AggregationType.AVG) {
                        propertyType = Double.class;
                    } else if (aggregationExpr.getAggregationType() == PropertyPath.AggregationType.COUNT) {
                        propertyType = Long.class;
                    }
                    int idx = columns.size();
                    c = new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType);
                    columns.put(p, c);
                }
                return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated());
            }
        }
        return (BooleanExpr)expr.acceptVisitor((Visitor)new PropertyReplacer());
    }

    private BaseQuery buildQueryNoAggregations(QueryFactory queryFactory, String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults, FilterParsingResult<?> parsingResult) {
        if (parsingResult.hasGroupingOrAggregations()) {
            throw new IllegalArgumentException("The query must not use grouping or aggregation");
        }
        BooleanExpr normalizedWhereClause = this.booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
        if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
            return new EmptyResultQuery(queryFactory, this.cache, jpqlString, namedParameters, startOffset, maxResults);
        }
        if (normalizedWhereClause == null || normalizedWhereClause == ConstantBooleanExpr.TRUE || this.searchManager == null) {
            return new EmbeddedQuery(this, queryFactory, this.cache, jpqlString, namedParameters, parsingResult.getProjections(), startOffset, maxResults);
        }
        BooleShannonExpansion bse = new BooleShannonExpansion(16, this.getIndexedFieldProvider(parsingResult));
        BooleanExpr expansion = bse.expand(normalizedWhereClause);
        if (expansion == normalizedWhereClause) {
            return new EmbeddedLuceneQuery(this, queryFactory, jpqlString, namedParameters, parsingResult.getProjections(), startOffset, maxResults);
        }
        if (expansion == ConstantBooleanExpr.TRUE) {
            return new EmbeddedQuery(this, queryFactory, this.cache, jpqlString, namedParameters, parsingResult.getProjections(), startOffset, maxResults);
        }
        String expandedJpaOut = JPATreePrinter.printTree((String)parsingResult.getTargetEntityName(), (BooleanExpr)expansion, null);
        EmbeddedLuceneQuery expandedQuery = new EmbeddedLuceneQuery(this, queryFactory, expandedJpaOut, namedParameters, parsingResult.getProjections(), -1L, -1);
        return new HybridQuery(queryFactory, this.cache, jpqlString, namedParameters, this.getObjectFilter(this.getSecondPhaseMatcher(), jpqlString, namedParameters), startOffset, maxResults, (Query)expandedQuery);
    }

    protected BaseMatcher getFirstPhaseMatcher() {
        return (BaseMatcher)SecurityActions.getCacheComponentRegistry(this.cache).getComponent(ReflectionMatcher.class);
    }

    protected BaseMatcher getSecondPhaseMatcher() {
        return this.getFirstPhaseMatcher();
    }

    private FilterParsingResult<?> parse(String jpqlString, Map<String, Object> namedParameters) {
        FilterParsingResult parsingResult;
        if (this.queryCache != null && (namedParameters == null || namedParameters.isEmpty())) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, FilterParsingResult.class);
            parsingResult = (FilterParsingResult)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.getFirstPhaseMatcher().parse(jpqlString, namedParameters);
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, parsingResult);
            }
        } else {
            parsingResult = this.getFirstPhaseMatcher().parse(jpqlString, namedParameters);
        }
        return parsingResult;
    }

    private ObjectFilter getObjectFilter(BaseMatcher matcher, String jpqlString, Map<String, Object> namedParameters) {
        ObjectFilter objectFilter;
        if (this.queryCache != null && (namedParameters == null || namedParameters.isEmpty())) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, matcher.getClass());
            objectFilter = (ObjectFilter)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (objectFilter == null) {
                objectFilter = matcher.getObjectFilter(jpqlString, namedParameters);
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, objectFilter);
            }
        } else {
            objectFilter = matcher.getObjectFilter(jpqlString, namedParameters);
        }
        return objectFilter;
    }

    protected BooleShannonExpansion.IndexedFieldProvider getIndexedFieldProvider(FilterParsingResult<?> parsingResult) {
        return new HibernateSearchIndexedFieldProvider(this.searchFactory, (Class)parsingResult.getTargetEntityMetadata());
    }

    protected JPAFilterAndConverter makeFilter(String jpaQuery, Map<String, Object> namedParameters) {
        final JPAFilterAndConverter filter = this.createFilter(jpaQuery, namedParameters);
        SecurityActions.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                filter.injectDependencies((Cache)QueryEngine.this.cache);
                return null;
            }
        });
        return filter;
    }

    protected JPAFilterAndConverter createFilter(String jpaQuery, Map<String, Object> namedParameters) {
        return new JPAFilterAndConverter(jpaQuery, namedParameters, ReflectionMatcher.class);
    }

    public CacheQuery buildLuceneQuery(String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults) {
        if (this.searchManager == null) {
            throw new IllegalStateException("Cannot run Lucene queries on a cache that does not have indexing enabled");
        }
        this.checkParameters(namedParameters);
        LuceneQueryParsingResult parsingResult = this.transformJpaToLucene(jpqlString, namedParameters);
        org.apache.lucene.search.Query luceneQuery = this.makeTypeQuery(parsingResult.getQuery(), parsingResult.getTargetEntityName());
        CacheQuery cacheQuery = this.searchManager.getQuery(luceneQuery, parsingResult.getTargetEntity());
        if (parsingResult.getSort() != null) {
            cacheQuery = cacheQuery.sort(parsingResult.getSort());
        }
        if (parsingResult.getProjections() != null && !parsingResult.getProjections().isEmpty()) {
            String[] projection = parsingResult.getProjections().toArray(new String[parsingResult.getProjections().size()]);
            cacheQuery = cacheQuery.projection(projection);
        }
        if (startOffset >= 0L) {
            cacheQuery = cacheQuery.firstResult((int)startOffset);
        }
        if (maxResults > 0) {
            cacheQuery = cacheQuery.maxResults(maxResults);
        }
        return cacheQuery;
    }

    protected org.apache.lucene.search.Query makeTypeQuery(org.apache.lucene.search.Query query, String targetEntityName) {
        return query;
    }

    private LuceneQueryParsingResult transformJpaToLucene(String jpqlString, Map<String, Object> namedParameters) {
        LuceneQueryParsingResult parsingResult;
        if (this.queryCache != null && (namedParameters == null || namedParameters.isEmpty())) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, LuceneQueryParsingResult.class);
            parsingResult = (LuceneQueryParsingResult)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (parsingResult == null) {
                parsingResult = (LuceneQueryParsingResult)this.queryParser.parseQuery(jpqlString, (AstProcessingChain)this.makeProcessingChain(namedParameters));
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, parsingResult);
            }
        } else {
            parsingResult = (LuceneQueryParsingResult)this.queryParser.parseQuery(jpqlString, (AstProcessingChain)this.makeProcessingChain(namedParameters));
        }
        return parsingResult;
    }

    protected LuceneProcessingChain makeProcessingChain(Map<String, Object> namedParameters) {
        final EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

            public Class<?> getClassFromName(String entityName) {
                try {
                    return Util.loadClassStrict((String)entityName, null);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        };
        FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){
            private final ClassBasedLucenePropertyHelper propertyHelper;
            {
                this.propertyHelper = new ClassBasedLucenePropertyHelper(QueryEngine.this.searchFactory, entityNamesResolver);
            }

            public FieldBridge getFieldBridge(String type, String propertyPath) {
                return this.propertyHelper.getFieldBridge(type, Arrays.asList(propertyPath.split("[.]")));
            }
        };
        return new LuceneProcessingChain.Builder(this.searchFactory, entityNamesResolver).namedParameters(namedParameters).buildProcessingChainForClassBasedEntities(fieldBridgeProvider);
    }
}

