/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hibernate.hql.ParsingException;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.query.dsl.embedded.testdomain.Transaction;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.dsl.embedded.QueryDslConditionsTest")
public class QueryDslConditionsTest
extends AbstractQueryDslTest {
    @BeforeClass(alwaysRun=true)
    protected void populateCache() throws Exception {
        User user1 = this.getModelFactory().makeUser();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        Address address1 = this.getModelFactory().makeAddress();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        user1.setAddresses(Collections.singletonList(address1));
        User user2 = this.getModelFactory().makeUser();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAccountIds(Collections.singleton(3));
        Address address2 = this.getModelFactory().makeAddress();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        Address address3 = this.getModelFactory().makeAddress();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        user2.setAddresses(Arrays.asList(address2, address3));
        User user3 = this.getModelFactory().makeUser();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAccountIds(Collections.emptySet());
        Account account1 = this.getModelFactory().makeAccount();
        account1.setId(1);
        account1.setDescription("John Doe's first bank account");
        account1.setCreationDate(this.makeDate("2013-01-03"));
        Account account2 = this.getModelFactory().makeAccount();
        account2.setId(2);
        account2.setDescription("John Doe's second bank account");
        account2.setCreationDate(this.makeDate("2013-01-04"));
        Account account3 = this.getModelFactory().makeAccount();
        account3.setId(3);
        account3.setCreationDate(this.makeDate("2013-01-20"));
        Transaction transaction0 = this.getModelFactory().makeTransaction();
        transaction0.setId(0);
        transaction0.setDescription("Birthday present");
        transaction0.setAccountId(1);
        transaction0.setAmount(1800.0);
        transaction0.setDate(this.makeDate("2012-09-07"));
        transaction0.setDebit(false);
        transaction0.setValid(true);
        Transaction transaction1 = this.getModelFactory().makeTransaction();
        transaction1.setId(1);
        transaction1.setDescription("Feb. rent payment");
        transaction1.setAccountId(1);
        transaction1.setAmount(1500.0);
        transaction1.setDate(this.makeDate("2013-01-05"));
        transaction1.setDebit(true);
        transaction1.setValid(true);
        Transaction transaction2 = this.getModelFactory().makeTransaction();
        transaction2.setId(2);
        transaction2.setDescription("Starbucks");
        transaction2.setAccountId(1);
        transaction2.setAmount(23.0);
        transaction2.setDate(this.makeDate("2013-01-09"));
        transaction2.setDebit(true);
        transaction2.setValid(true);
        Transaction transaction3 = this.getModelFactory().makeTransaction();
        transaction3.setId(3);
        transaction3.setDescription("Hotel");
        transaction3.setAccountId(2);
        transaction3.setAmount(45.0);
        transaction3.setDate(this.makeDate("2013-02-27"));
        transaction3.setDebit(true);
        transaction3.setValid(true);
        Transaction transaction4 = this.getModelFactory().makeTransaction();
        transaction4.setId(4);
        transaction4.setDescription("Last january");
        transaction4.setAccountId(2);
        transaction4.setAmount(95.0);
        transaction4.setDate(this.makeDate("2013-01-31"));
        transaction4.setDebit(true);
        transaction4.setValid(true);
        Transaction transaction5 = this.getModelFactory().makeTransaction();
        transaction5.setId(5);
        transaction5.setDescription("-Popcorn");
        transaction5.setAccountId(2);
        transaction5.setAmount(5.0);
        transaction5.setDate(this.makeDate("2013-01-01"));
        transaction5.setDebit(true);
        transaction5.setValid(true);
        this.getCacheForWrite().put((Object)("user_" + user1.getId()), (Object)user1);
        this.getCacheForWrite().put((Object)("user_" + user2.getId()), (Object)user2);
        this.getCacheForWrite().put((Object)("user_" + user3.getId()), (Object)user3);
        this.getCacheForWrite().put((Object)("account_" + account1.getId()), (Object)account1);
        this.getCacheForWrite().put((Object)("account_" + account2.getId()), (Object)account2);
        this.getCacheForWrite().put((Object)("account_" + account3.getId()), (Object)account3);
        this.getCacheForWrite().put((Object)("transaction_" + transaction0.getId()), (Object)transaction0);
        this.getCacheForWrite().put((Object)("transaction_" + transaction1.getId()), (Object)transaction1);
        this.getCacheForWrite().put((Object)("transaction_" + transaction2.getId()), (Object)transaction2);
        this.getCacheForWrite().put((Object)("transaction_" + transaction3.getId()), (Object)transaction3);
        this.getCacheForWrite().put((Object)("transaction_" + transaction4.getId()), (Object)transaction4);
        this.getCacheForWrite().put((Object)("transaction_" + transaction5.getId()), (Object)transaction5);
        for (int i = 0; i < 50; ++i) {
            Transaction transaction = this.getModelFactory().makeTransaction();
            transaction.setId(50 + i);
            transaction.setDescription("Expensive shoes " + i);
            transaction.setAccountId(2);
            transaction.setAmount(100 + i);
            transaction.setDate(this.makeDate("2013-08-20"));
            transaction.setDebit(true);
            transaction.setValid(true);
            this.getCacheForWrite().put((Object)("transaction_" + transaction.getId()), (Object)transaction);
        }
        this.getCacheForWrite().put((Object)"dummy", (Object)"a primitive value cannot be queried");
        this.getCacheForWrite().put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        this.getCacheForWrite().put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
    }

    public void testIndexPresence() {
        SearchIntegrator searchIntegrator = (SearchIntegrator)Search.getSearchManager((Cache)((Cache)this.getCacheForQuery())).unwrap(SearchIntegrator.class);
        Assert.assertTrue((boolean)searchIntegrator.getIndexedTypes().contains(this.getModelFactory().getUserImplClass()));
        Assert.assertNotNull((Object)searchIntegrator.getIndexManager(this.getModelFactory().getUserImplClass().getName()));
        Assert.assertTrue((boolean)searchIntegrator.getIndexedTypes().contains(this.getModelFactory().getAccountImplClass()));
        Assert.assertNotNull((Object)searchIntegrator.getIndexManager(this.getModelFactory().getAccountImplClass().getName()));
        Assert.assertTrue((boolean)searchIntegrator.getIndexedTypes().contains(this.getModelFactory().getTransactionImplClass()));
        Assert.assertNotNull((Object)searchIntegrator.getIndexManager(this.getModelFactory().getTransactionImplClass().getName()));
        Assert.assertFalse((boolean)searchIntegrator.getIndexedTypes().contains(this.getModelFactory().getAddressImplClass()));
        Assert.assertNull((Object)searchIntegrator.getIndexManager(this.getModelFactory().getAddressImplClass().getName()));
    }

    public void testQueryFactoryType() {
        Assert.assertEquals(EmbeddedQueryFactory.class, this.getQueryFactory().getClass());
    }

    public void testEq1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    public void testEqEmptyString() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"").toBuilder().build();
        List list = q.list();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    public void testEqSentence() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("description").eq((Object)"John Doe's first bank account").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
    }

    public void testEq() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Jacob").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testEqNonIndexedType() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(NotIndexed.class).having("notIndexedField").eq((Object)"testing 123").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"testing 123", (Object)((NotIndexed)list.get((int)0)).notIndexedField);
    }

    public void testEqNonIndexedField() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testEqHybridQuery() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet").and().having("surname").eq((Object)"Doe").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testEqHybridQueryWithParam() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet").and().having("surname").eq((Object)Expression.param((String)"surnameParam")).toBuilder().build();
        q.setParameter("surnameParam", (Object)"Doe");
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testEqHybridQueryWithPredicateOptimisation() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").like("%ipsum%").and(qf.having("name").eq((Object)"John").or().having("name").eq((Object)"Jane")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Lorem ipsum dolor sit amet", (Object)((User)list.get(0)).getNotes());
    }

    public void testEqInNested1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses.postCode").eq((Object)"X1234").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"X1234", (Object)((User)list.get(0)).getAddresses().get(0).getPostCode());
    }

    public void testEqInNested2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses.postCode").eq((Object)"Y12").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getAddresses().size());
    }

    public void testLike() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("description").like("%rent%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getAccountId());
        Assert.assertEquals((double)1500.0, (double)((Transaction)list.get(0)).getAmount(), (double)0.0);
    }

    public void testBetween1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testBetween2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).includeUpper(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testBetween3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).includeLower(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) > 0 ? 1 : 0) != 0);
        }
    }

    public void testGt() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").gt((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((((Transaction)list.get(0)).getAmount() > 1500.0 ? 1 : 0) != 0);
    }

    public void testGte() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").gte((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() >= 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLt() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").lt((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)54L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() < 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLte() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").lte((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)55L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() <= 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLteOnFieldWithNullToken() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("description").lte((Object)"-Popcorn").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"-Popcorn", (Object)((Transaction)list.get(0)).getDescription());
    }

    public void testAnd1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider").and().having("surname").eq((Object)"Man").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
    }

    public void testAnd2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider").and(qf.having("surname").eq((Object)"Man")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
    }

    public void testAnd3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE).and().having("gender").eq((Object)User.Gender.FEMALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testAnd4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider").or(qf.having("name").eq((Object)"John")).and(qf.having("surname").eq((Object)"Man")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    public void testOr1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man").or().having("surname").eq((Object)"Woman").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertEquals((Object)"Spider", (Object)u.getName());
        }
    }

    public void testOr2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man").or(qf.having("surname").eq((Object)"Woman")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertEquals((Object)"Spider", (Object)u.getName());
        }
    }

    public void testOr3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE).or().having("gender").eq((Object)User.Gender.FEMALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testOr4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("surname", SortOrder.DESC).having("gender").eq((Object)User.Gender.MALE).or().having("name").eq((Object)"Spider").and().having("gender").eq((Object)User.Gender.FEMALE).or().having("surname").like("%oe%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(1)).getSurname());
    }

    public void testOr5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE).or().having("name").eq((Object)"Spider").or().having("gender").eq((Object)User.Gender.FEMALE).and().having("surname").like("%oe%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    public void testNot1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"Spider").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    public void testNot2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().not().having("surname").eq((Object)"Doe").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    public void testNot3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"John").and().having("surname").eq((Object)"Man").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
    }

    public void testNot4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man").and().not().having("name").eq((Object)"John").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
    }

    public void testNot5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"Spider").or().having("surname").eq((Object)"Man").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertFalse((boolean)"Woman".equals(u.getSurname()));
        }
    }

    public void testNot6() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.not(qf.having("gender").eq((Object)User.Gender.FEMALE))).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)((User)list.get(0)).getSurname().equals("Woman"));
    }

    public void testNot7() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.FEMALE).and().not(qf.having("name").eq((Object)"Spider")).toBuilder().build();
        List list = q.list();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    public void testNot8() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.having("name").eq((Object)"John").or(qf.having("surname").eq((Object)"Man"))).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
    }

    public void testNot9() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.having("name").eq((Object)"John").and(qf.having("surname").eq((Object)"Doe"))).toBuilder().orderBy("id", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Man", (Object)((User)list.get(0)).getSurname());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(1)).getSurname());
    }

    public void testNot10() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().not(qf.having("name").eq((Object)"John").or(qf.having("surname").eq((Object)"Man"))).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertNotEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
    }

    public void testNot11() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.not(qf.having("name").eq((Object)"John").or(qf.having("surname").eq((Object)"Man")))).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertNotEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
    }

    public void testEmptyQuery() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testTautology() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").gt((Object)"A").or().having("name").lte((Object)"A").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testContradiction() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").gt((Object)"A").and().having("name").lte((Object)"A").toBuilder().build();
        List list = q.list();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN000405:.*")
    public void testInvalidEmbeddedAttributeQuery() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        QueryBuilder queryBuilder = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"addresses"});
        Query q = queryBuilder.build();
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014027: The property path 'addresses.postCode' cannot be projected because it is multi-valued")
    public void testRejectProjectionOfRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"addresses.postCode"}).build();
        q.list();
    }

    public void testIsNull1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("surname").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testIsNull2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("surname").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testIsNull3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((User)list.get(0)).getId());
    }

    public void testIsNullNumericWithProjection1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name", "surname", "age"}).orderBy("name", SortOrder.ASC).orderBy("surname", SortOrder.ASC).orderBy("age", SortOrder.ASC).having("age").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Man", (Object)((Object[])list.get(0))[1]);
        Assert.assertNull((Object)((Object[])list.get(0))[2]);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"Woman", (Object)((Object[])list.get(1))[1]);
        Assert.assertNull((Object)((Object[])list.get(1))[2]);
    }

    public void testIsNullNumericWithProjection2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name", "age"}).not().having("age").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)22, (Object)((Object[])list.get(0))[1]);
    }

    public void testContains1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)2).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testContains2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)42).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testContainsAll1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{1, 2}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testContainsAll2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(Collections.singleton(1)).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testContainsAll3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{1, 2, 3}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testContainsAll4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(Collections.emptySet()).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testContainsAny1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).having("accountIds").containsAny(new Object[]{2, 3}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((User)list.get(1)).getId());
    }

    public void testContainsAny2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAny(new Object[]{4, 5}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testContainsAny3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAny(Collections.emptySet()).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testIn1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        List<Integer> ids = Arrays.asList(1, 3);
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").in(ids).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertTrue((boolean)ids.contains(u.getId()));
        }
    }

    public void testIn2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").in(new Object[]{4}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in(Collections.emptySet());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Collection collection = null;
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in(collection);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Object[] array = null;
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in(array);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn6() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Object[] array = new Object[]{};
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in(array);
    }

    public void testSampleDomainQuery1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).having("gender").eq((Object)User.Gender.MALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    public void testSampleDomainQuery2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).not(qf.having("gender").eq((Object)User.Gender.FEMALE)).and(qf.not().not(qf.having("gender").eq((Object)User.Gender.MALE))).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    public void testStringLiteralEscape() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("description").eq((Object)"John Doe's first bank account").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
    }

    public void testSortByDate() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("creationDate", SortOrder.DESC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Account)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Account)list.get(1)).getId());
        Assert.assertEquals((long)1L, (long)((Account)list.get(2)).getId());
    }

    public void testSampleDomainQuery3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).having("gender").eq((Object)User.Gender.MALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    public void testSampleDomainQuery4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(2)).getName());
    }

    public void testSampleDomainQuery4With2SortingOptions() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).orderBy("surname", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(2)).getName());
        Assert.assertEquals((Object)"Man", (Object)((User)list.get(0)).getSurname());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(1)).getSurname());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(2)).getSurname());
    }

    public void testSampleDomainQuery5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).select(new String[]{"name"}).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(2))[0]);
    }

    public void testSampleDomainQuery6() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").and().having("surname").eq((Object)"Doe").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    public void testSampleDomainQuery7() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)1).and().having("description").like("%rent%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getId());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getAccountId());
        Assert.assertTrue((boolean)((Transaction)list.get(0)).getDescription().contains("rent"));
    }

    public void testSampleDomainQuery8() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSampleDomainQuery9() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(3)).length);
        for (int i = 0; i < 4; ++i) {
            Date d = (Date)((Object[])list.get(i))[0];
            Assert.assertTrue((d.compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((d.compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSampleDomainQuery10() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)2).and().having("amount").gt((Object)40).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)52L, (long)list.size());
        Assert.assertTrue((((Transaction)list.get(0)).getAmount() > 40.0 ? 1 : 0) != 0);
        Assert.assertTrue((((Transaction)list.get(1)).getAmount() > 40.0 ? 1 : 0) != 0);
    }

    public void testSampleDomainQuery11() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").and().having("addresses.postCode").eq((Object)"X1234").and(qf.having("accountIds").eq((Object)1)).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    public void testSampleDomainQuery12() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)1).and().not().having("isDebit").eq((Object)true).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertFalse((boolean)((Transaction)list.get(0)).isDebit());
    }

    public void testSampleDomainQuery13() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)3).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(3));
    }

    public void testSampleDomainQuery14() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{2, 1}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(1));
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(2));
    }

    public void testSampleDomainQuery15() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAny(new Object[]{1, 3}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery16() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).startOffset(20L).maxResults(10).orderBy("id", SortOrder.ASC).having("accountId").eq((Object)2).and().having("description").like("Expensive%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)50L, (long)q.getResultSize());
        Assert.assertEquals((long)10L, (long)list.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("Expensive shoes " + (20 + i)), (Object)((Transaction)list.get(i)).getDescription());
        }
    }

    public void testSampleDomainQuery17() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q1 = qf.from(this.getModelFactory().getUserImplClass()).having("id").eq((Object)1).toBuilder().build();
        List users = q1.list();
        Query q2 = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("description", SortOrder.ASC).having("id").in(((User)users.get(0)).getAccountIds()).toBuilder().build();
        List list = q2.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John Doe's first bank account", (Object)((Account)list.get(0)).getDescription());
        Assert.assertEquals((Object)"John Doe's second bank account", (Object)((Account)list.get(1)).getDescription());
    }

    public void testSampleDomainQuery18() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).orderBy("description", SortOrder.ASC).having("accountId").eq((Object)1).and(qf.having("amount").gt((Object)1600).or().having("description").like("%rent%")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Birthday present", (Object)((Transaction)list.get(0)).getDescription());
        Assert.assertEquals((Object)"Feb. rent payment", (Object)((Transaction)list.get(1)).getDescription());
    }

    public void testProjectionOnOptionalField() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"id", "age"}).orderBy("id", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)1, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(2))[0]);
        Assert.assertEquals((Object)22, (Object)((Object[])list.get(0))[1]);
        Assert.assertNull((Object)((Object[])list.get(1))[1]);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testNullOnIntegerField() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("age").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertNull((Object)((User)list.get(0)).getAge());
        Assert.assertNull((Object)((User)list.get(1)).getAge());
    }

    public void testIsNotNullOnIntegerField() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("age").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
        Assert.assertNotNull((Object)((User)list.get(0)).getAge());
    }

    public void testSampleDomainQuery19() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses.postCode").in(new Object[]{"ZZ", "X1234"}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery20() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("addresses.postCode").in(new Object[]{"X1234"}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery21() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("addresses").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery22() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("addresses.postCode").like("%123%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery23() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((User)list.get(0)).getId());
    }

    public void testSampleDomainQuery24() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).includeLower(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery25() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).includeUpper(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery26() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("creationDate").eq((Object)this.makeDate("2013-01-20")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Account)list.get(0)).getId());
    }

    public void testSampleDomainQuery27() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("id", SortOrder.ASC).having("creationDate").lt((Object)this.makeDate("2013-01-20")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Account)list.get(1)).getId());
    }

    public void testSampleDomainQuery28() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("id", SortOrder.ASC).having("creationDate").lte((Object)this.makeDate("2013-01-20")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Account)list.get(1)).getId());
        Assert.assertEquals((long)3L, (long)((Account)list.get(2)).getId());
    }

    public void testSampleDomainQuery29() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("creationDate").gt((Object)this.makeDate("2013-01-04")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Account)list.get(0)).getId());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.not().having("name").eq((Object)"John").toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").toBuilder().having("surname").eq((Object)"Man").toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"John").toBuilder().not().having("surname").eq((Object)"Man").toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.having("name").eq((Object)"John")).toBuilder().not(qf.having("surname").eq((Object)"Man")).toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.having("name").eq((Object)"John")).toBuilder().not(qf.having("surname").eq((Object)"Man")).toBuilder().build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWrongQueryBuilding6() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq(null).toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding7() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        FilterConditionEndContext q1 = qf.from(this.getModelFactory().getUserImplClass()).having("gender");
        q1.eq((Object)User.Gender.MALE);
        q1.eq((Object)User.Gender.FEMALE);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="maxResults must be greater than 0")
    public void testPagination1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).maxResults(0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="maxResults must be greater than 0")
    public void testPagination2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).maxResults(-4);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="startOffset cannot be less than 0")
    public void testPagination3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).startOffset(-3L);
    }

    public void testOrderedPagination4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).maxResults(5).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testUnorderedPagination4() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).maxResults(5).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testOrderedPagination5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(20L).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testUnorderedPagination5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).startOffset(20L).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testOrderedPagination6() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(20L).maxResults(10).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testUnorderedPagination6() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).startOffset(20L).maxResults(10).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testOrderedPagination7() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(1L).maxResults(10).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    public void testUnorderedPagination7() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).startOffset(1L).maxResults(10).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    public void testOrderedPagination8() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(0L).maxResults(2).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    public void testUnorderedPagination8() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).startOffset(0L).maxResults(2).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    public void testGroupBy1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
    }

    public void testGroupBy2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals(null, (Object)((Object[])list.get(1))[0]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'surname' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testGroupBy3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).groupBy(new String[]{"name"}).orderBy("surname").build();
        q.list();
    }

    public void testGroupBy4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"addresses.postCode")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"ZZ", (Object)((Object[])list.get(1))[0]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014021: Queries containing grouping and aggregation functions must use projections.")
    public void testGroupBy5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).groupBy(new String[]{"name"}).build();
        q.list();
    }

    public void testGroupBy6() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.sum((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.sum((String)"amount")).gt((Object)3324).toBuilder().orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)6370.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testGroupBy7() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.avg((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.avg((String)"amount")).lt((Object)130.0).toBuilder().orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)120.188679, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testGroupBy8() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.min((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.min((String)"amount")).lt((Object)10).toBuilder().orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)5.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testGroupBy9() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.max((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.avg((String)"amount")).lt((Object)150).toBuilder().orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)149.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testGlobalMin() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"name")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
    }

    public void testMin() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"surname")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Doe", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Man", (Object)((Object[])list.get(1))[0]);
    }

    public void testGlobalMax() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"name")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
    }

    public void testMax() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"surname")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Doe", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Woman", (Object)((Object[])list.get(1))[0]);
    }

    public void testOrderBySum() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).orderBy(Expression.sum((String)"age")).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
    }

    public void testGroupingWithFilter() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).having("name").eq((Object)"John").toBuilder().groupBy(new String[]{"name"}).having("name").eq((Object)"John").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
    }

    public void testCountNull() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"age")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
    }

    public void testAvgNull() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"age")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22.0, (Object)((Object[])list.get(0))[0]);
    }

    public void testDateGrouping1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-02-15"), (Object)this.makeDate("2013-03-15")).toBuilder().groupBy(new String[]{"date"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
    }

    public void testDateGrouping2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.count((String)"date"), Expression.min((String)"date")}).having("description").eq((Object)"Hotel").toBuilder().groupBy(new String[]{"id"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
    }

    public void testDateGrouping3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.min((String)"date"), Expression.count((String)"date")}).having("description").eq((Object)"Hotel").toBuilder().groupBy(new String[]{"id"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
    }

    public void testParam() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)Expression.param((String)"param2")).toBuilder().build();
        q.setParameter("param2", (Object)User.Gender.MALE);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
        Assert.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(1)).getGender()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="No parameter named 'param2' was found")
    public void testUnknownParam() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1")).toBuilder().build();
        q.setParameter("param2", (Object)"John");
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014020: Query parameter 'param2' was not set")
    public void testMissingParam() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1")).and().having("gender").eq((Object)Expression.param((String)"param2")).toBuilder().build();
        q.setParameter("param1", (Object)"John");
        q.list();
    }

    public void testNotIndexedProjection() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isValid"}).having("id").gte((Object)98).toBuilder().orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(1))[1]);
    }

    public void testNotStoredProjection() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "description"}).having("id").gte((Object)98).toBuilder().orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Expensive shoes 48", (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"Expensive shoes 49", (Object)((Object[])list.get(1))[1]);
    }

    public void testNotIndexedOrderBy() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isValid"}).having("id").gte((Object)98).toBuilder().orderBy("isValid").orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(1))[1]);
    }

    public void testNotStoredOrderBy() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "description"}).having("id").gte((Object)98).toBuilder().orderBy("description").orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Expensive shoes 48", (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"Expensive shoes 49", (Object)((Object[])list.get(1))[1]);
    }

    public void testDuplicateDateProjection() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "date", "date"}).having("description").eq((Object)"Hotel").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[2]);
    }

    public void testDuplicateBooleanProjection() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isDebit", "isDebit"}).having("description").eq((Object)"Hotel").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[2]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014023: Using the multi-valued property path 'addresses.street' in the GROUP BY clause is not currently supported")
    public void testGroupByMustNotAcceptRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"name")}).groupBy(new String[]{"addresses.street"}).build();
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014024: The property path 'addresses.street' cannot be used in the ORDER BY clause because it is multi-valued")
    public void testOrderByMustNotAcceptRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).orderBy("addresses.street").build();
        q.list();
    }

    public void testOrderByInAggregationQueryMustAcceptRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"age"), Expression.property((String)"name")}).having("name").gt((Object)"A").toBuilder().groupBy(new String[]{"name"}).having(Expression.max((String)"addresses.street")).gt((Object)"A").toBuilder().orderBy(Expression.min((String)"addresses.street")).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertNull((Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)22.0, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(1))[1]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="HQL000009: Cannot have aggregate functions in WHERE clause : MIN.")
    public void testRejectAggregationsInWhereClause() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).having("name").eq((Object)Expression.min((String)"addresses.street")).toBuilder().build();
        q.list();
    }

    public void testAggregateRepeatedField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"addresses.street")}).having("name").eq((Object)"Spider").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((Object)((Object[])list.get(0))[0], (Object)"Bond Street");
    }
}

