/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.aggregation.Grouper;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.HybridQuery;
import org.infinispan.query.dsl.impl.BaseQuery;

final class AggregatingQuery
extends HybridQuery {
    private final int noOfGroupingColumns;
    private final FieldAccumulator[] accumulators;

    AggregatingQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String jpaQuery, Map<String, Object> namedParameters, int noOfGroupingColumns, FieldAccumulator[] accumulators, ObjectFilter objectFilter, long startOffset, int maxResults, BaseQuery baseQuery) {
        super(queryFactory, cache, jpaQuery, namedParameters, objectFilter, startOffset, maxResults, (Query)baseQuery);
        if (baseQuery.getProjection() == null) {
            throw new IllegalArgumentException("Base query must use projections");
        }
        if (this.projection == null) {
            throw new IllegalArgumentException("Aggregating query must use projections");
        }
        this.noOfGroupingColumns = noOfGroupingColumns;
        this.accumulators = accumulators;
    }

    @Override
    protected Iterator<?> getBaseIterator() {
        Grouper grouper = new Grouper(this.noOfGroupingColumns, this.accumulators);
        List list = this.baseQuery.list();
        for (Object[] row : list) {
            grouper.addRow(row);
        }
        return grouper.finish();
    }

    @Override
    public String toString() {
        return "AggregatingQuery{jpaQuery=" + this.jpaQuery + ", namedParameters=" + this.namedParameters + ", noOfGroupingColumns=" + this.noOfGroupingColumns + ", accumulators=" + Arrays.toString(this.accumulators) + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", baseQuery=" + this.baseQuery + '}';
    }
}

