/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.queries.faceting.Car;

public class MassIndexingWithStoreTest
extends DistributedMassIndexingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = MassIndexingWithStoreTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.eviction().size(1L).strategy(EvictionStrategy.LRU);
        ((DummyInMemoryStoreConfigurationBuilder)cacheCfg.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(((Object)((Object)this)).getClass().getSimpleName()).purgeOnStartup(true);
        cacheCfg.storeAsBinary().enable();
        cacheCfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        List cacheList = this.createClusteredCaches(2, cacheCfg);
        this.waitForClusterToForm(neededCacheNames);
        this.caches.addAll(cacheList.stream().collect(Collectors.toList()));
    }

    @Override
    public void testReindexing() throws Exception {
        Cache cache0 = (Cache)this.caches.get(0);
        for (int i = 0; i < 10; ++i) {
            cache0.put((Object)("CAR#" + i), (Object)new Car("Volkswagen", "white", 200));
        }
        this.rebuildIndexes();
        this.verifyFindsCar(10, "Volkswagen");
    }
}

