/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.apache.lucene.search.Query;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.context.Flag;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DegeneratedClusterMassIndexingTest")
public class DegeneratedClusterMassIndexingTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = DegeneratedClusterMassIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(Car.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.addClusterEnabledCacheManager(cfg);
        this.waitForClusterToForm();
    }

    public void testReindexing() throws Exception {
        AdvancedCache cache = this.cache(0).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        Query query = searchManager.buildQueryBuilderForClass(Car.class).get().keyword().onField("make").matching((Object)"ford").createQuery();
        cache.put((Object)"car1", (Object)new Car("ford", "white", 300));
        cache.put((Object)"car2", (Object)new Car("ford", "blue", 300));
        cache.put((Object)"car3", (Object)new Car("ford", "red", 300));
        Assert.assertEquals((long)0L, (long)searchManager.getQuery(query, new Class[]{Car.class}).getResultSize());
        searchManager.getMassIndexer().start();
        Assert.assertEquals((long)3L, (long)searchManager.getQuery(query, new Class[]{Car.class}).getResultSize());
    }
}

