/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.query.Transformable;
import org.infinispan.query.Transformer;

@SerializeWith(value=CustomExternalizer.class)
@Transformable(transformer=CustomTransformer.class)
public class NonSerializableKeyType {
    public final String keyValue;

    public NonSerializableKeyType(String keyValue) {
        this.keyValue = keyValue;
    }

    public int hashCode() {
        return this.keyValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NonSerializableKeyType other = (NonSerializableKeyType)obj;
        return !(this.keyValue == null ? other.keyValue != null : !this.keyValue.equals(other.keyValue));
    }

    public static class CustomTransformer
    implements Transformer {
        public Object fromString(String s) {
            return new NonSerializableKeyType(s);
        }

        public String toString(Object customType) {
            return ((NonSerializableKeyType)customType).keyValue;
        }
    }

    public static class CustomExternalizer
    implements Externalizer<NonSerializableKeyType> {
        public void writeObject(ObjectOutput output, NonSerializableKeyType object) throws IOException {
            output.writeUTF(object.keyValue);
        }

        public NonSerializableKeyType readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new NonSerializableKeyType(input.readUTF());
        }
    }
}

