/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.ModelFactoryHS;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;

@CleanupAfterTest
public abstract class AbstractQueryDslTest
extends MultipleCacheManagersTest {
    protected final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    protected AbstractQueryDslTest() {
        this.DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected Date makeDate(String dateStr) throws ParseException {
        return this.DATE_FORMAT.parse(dateStr);
    }

    protected BasicCache<Object, Object> getCacheForWrite() {
        return this.getCacheForQuery();
    }

    protected BasicCache<Object, Object> getCacheForQuery() {
        return this.cache(0);
    }

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory((Cache)((Cache)this.getCacheForQuery()));
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryHS.INSTANCE;
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(this.getModelFactory().getUserImplClass()).addIndexedEntity(this.getModelFactory().getAccountImplClass()).addIndexedEntity(this.getModelFactory().getTransactionImplClass()).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(1, cfg);
    }

    protected void clearContent() {
    }
}

