/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.dsl.embedded.ClusteredListenerWithDslFilterProfilingTest")
public class ClusteredListenerWithDslFilterProfilingTest
extends MultipleCacheManagersTest {
    private final int NUM_NODES = 10;
    private final int NUM_OWNERS = 3;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = ClusteredListenerWithDslFilterProfilingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cfgBuilder.clustering().hash().numOwners(3);
        this.createClusteredCaches(10, cfgBuilder);
    }

    public void testEventFilterPerformance() {
        long t1 = this.testEventFilterPerformance(false);
        long t2 = this.testEventFilterPerformance(true);
        this.log.infof("ClusteredListenerWithDslFilterProfilingTest.testEventFilterPerformance doRegisterListener=false took %d ms\n", (Object)(t1 / 1000000L));
        this.log.infof("ClusteredListenerWithDslFilterProfilingTest.testEventFilterPerformance doRegisterListener=true  took %d ms\n", (Object)(t2 / 1000000L));
    }

    private long testEventFilterPerformance(boolean doRegisterListener) {
        Cache cache;
        Person value;
        int i;
        int numEntries = 100000;
        int numListeners = 1000;
        ArrayList<NoOpEntryListener> listeners = new ArrayList<NoOpEntryListener>(1000);
        if (doRegisterListener) {
            Query query = this.makeQuery(this.cache(0));
            for (int i2 = 0; i2 < 1000; ++i2) {
                NoOpEntryListener listener = new NoOpEntryListener();
                listeners.add(listener);
                this.cache(0).addListener((Object)listener, (CacheEventFilter)Search.makeFilter((Query)query), null);
            }
        }
        long startTs = System.nanoTime();
        for (i = 0; i < 100000; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 10);
            cache.put((Object)value.getName(), (Object)value);
        }
        for (i = 0; i < 100000; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 10);
            cache.put((Object)value.getName(), (Object)value);
        }
        long endTs = System.nanoTime();
        for (NoOpEntryListener listener : listeners) {
            this.cache(0).removeListener((Object)listener);
        }
        return endTs - startTs;
    }

    private Query makeQuery(Cache c) {
        QueryFactory qf = Search.getQueryFactory((Cache)c);
        return qf.from(Person.class).having("age").gte((Object)18).toBuilder().build();
    }

    @Listener(clustered=true)
    private static class NoOpEntryListener {
        private NoOpEntryListener() {
        }

        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent<?, ?> event) {
        }

        @CacheEntryModified
        public void handleEvent(CacheEntryModifiedEvent<?, ?> event) {
        }
    }
}

