/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.nulls;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.nulls.NullCollectionElementsClusteredTest")
public class NullCollectionElementsClusteredTest
extends MultipleCacheManagersTest {
    private Cache cache1;
    private Cache cache2;
    private SearchManager searchManager;

    public void testQuerySkipsNullsInList() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(1), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache2.remove((Object)"2");
                NullCollectionElementsClusteredTest.this.searchManager = Search.getSearchManager((Cache)NullCollectionElementsClusteredTest.this.cache1);
                Query query = NullCollectionElementsClusteredTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"2").createQuery();
                List list = NullCollectionElementsClusteredTest.this.searchManager.getQuery(query, new Class[0]).list();
                AssertJUnit.assertEquals((String)"Wrong list size.", (int)0, (int)list.size());
                return null;
            }
        });
    }

    public void testQuerySkipsNullsInEagerIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache1.remove((Object)"1");
                NullCollectionElementsClusteredTest.this.searchManager = Search.getSearchManager((Cache)NullCollectionElementsClusteredTest.this.cache1);
                Query query = NullCollectionElementsClusteredTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                ResultIterator iterator = NullCollectionElementsClusteredTest.this.searchManager.getQuery(query, new Class[0]).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));
                AssertJUnit.assertFalse((String)"Iterator should not have elements.", (boolean)iterator.hasNext());
                try {
                    iterator.next();
                    AssertJUnit.fail((String)"Expected NoSuchElementException");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void testQuerySkipsNullsInDefaultIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache1.remove((Object)"1");
                NullCollectionElementsClusteredTest.this.searchManager = Search.getSearchManager((Cache)NullCollectionElementsClusteredTest.this.cache1);
                Query query = NullCollectionElementsClusteredTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                ResultIterator iterator = NullCollectionElementsClusteredTest.this.searchManager.getQuery(query, new Class[0]).iterator();
                AssertJUnit.assertFalse((boolean)iterator.hasNext());
                try {
                    iterator.next();
                    AssertJUnit.fail((String)"Expected NoSuchElementException");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void testQuerySkipsNullsInCacheQueryIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache1.remove((Object)"1");
                NullCollectionElementsClusteredTest.this.searchManager = Search.getSearchManager((Cache)NullCollectionElementsClusteredTest.this.cache1);
                Query query = NullCollectionElementsClusteredTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                CacheQuery cacheQuery = NullCollectionElementsClusteredTest.this.searchManager.getQuery(query, new Class[0]);
                AssertJUnit.assertEquals((String)"Wrong result size.", (int)1, (int)cacheQuery.getResultSize());
                for (Object obj : cacheQuery) {
                    AssertJUnit.fail((String)("The iterator should not contain any data but it contains " + obj));
                }
                return null;
            }
        });
    }

    public void testQuerySkipsNullsInLazyIterator() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(1), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache2.remove((Object)"2");
                NullCollectionElementsClusteredTest.this.searchManager = Search.getSearchManager((Cache)NullCollectionElementsClusteredTest.this.cache1);
                Query query = NullCollectionElementsClusteredTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"2").createQuery();
                ResultIterator iterator = NullCollectionElementsClusteredTest.this.searchManager.getQuery(query, new Class[0]).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
                AssertJUnit.assertFalse((boolean)iterator.hasNext());
                try {
                    iterator.next();
                    AssertJUnit.fail((String)"Expected NoSuchElementException");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void testQueryReturnsNullWhenProjectingCacheValue() throws Exception {
        this.prepareData();
        TestingUtil.withTx((TransactionManager)this.tm(0), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache1.remove((Object)"1");
                NullCollectionElementsClusteredTest.this.searchManager = Search.getSearchManager((Cache)NullCollectionElementsClusteredTest.this.cache1);
                Query query = NullCollectionElementsClusteredTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                ResultIterator iterator = NullCollectionElementsClusteredTest.this.searchManager.getQuery(query, new Class[0]).projection(new String[]{"__HSearch_This", "bar"}).iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
                AssertJUnit.assertTrue((String)"Expected an element in iterator.", (boolean)iterator.hasNext());
                Object[] projection = (Object[])iterator.next();
                AssertJUnit.assertNull((Object)projection[0]);
                AssertJUnit.assertEquals((Object)"1", (Object)projection[1]);
                return null;
            }
        });
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = NullCollectionElementsClusteredTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        cfg.indexing().index(Index.LOCAL).addIndexedEntity(Foo.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, cfg);
        this.cache1 = this.cache(0);
        this.cache2 = this.cache(1);
    }

    private QueryBuilder createQueryBuilder() {
        return this.searchManager.buildQueryBuilderForClass(Foo.class).get();
    }

    private void prepareData() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(0), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache1.put((Object)"1", (Object)new Foo("1"));
                return null;
            }
        });
        TestingUtil.withTx((TransactionManager)this.tm(1), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsClusteredTest.this.cache2.put((Object)"2", (Object)new Foo("2"));
                return null;
            }
        });
    }

    @Indexed(index="FooIndex")
    public static class Foo
    implements Serializable {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar", store=Store.YES)
        public String getBar() {
            return this.bar;
        }
    }
}

