/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.context.Flag;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.Person;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MultipleEntitiesMassIndexTest")
public class MultipleEntitiesMassIndexTest
extends DistributedMassIndexingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = MultipleEntitiesMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.indexing().index(Index.ALL).addIndexedEntity(Car.class).addIndexedEntity(Person.class).addProperty("hibernate.search.person.directory_provider", "ram").addProperty("hibernate.search.car.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        List cacheList = this.createClusteredCaches(2, cacheCfg);
        this.waitForClusterToForm("___defaultcache");
        for (Cache cache : cacheList) {
            this.caches.add(cache);
        }
    }

    @Override
    public void testReindexing() throws Exception {
        ((Cache)this.caches.get(0)).put(this.key("C1"), (Object)new Car("megane", "white", 300));
        ((Cache)this.caches.get(1)).put(this.key("P1"), (Object)new Person("james", "blurb", 23));
        ((Cache)this.caches.get(1)).put(this.key("P2"), (Object)new Person("tony", "blurb", 28));
        ((Cache)this.caches.get(1)).put(this.key("P3"), (Object)new Person("chris", "blurb", 26));
        ((Cache)this.caches.get(1)).put(this.key("P4"), (Object)new Person("iker", "blurb", 23));
        ((Cache)this.caches.get(1)).put(this.key("P5"), (Object)new Person("sergio", "blurb", 29));
        this.checkIndex(5, Person.class);
        this.checkIndex(1, Car.class);
        this.checkIndex(1, "make", "megane", Car.class);
        this.checkIndex(1, "name", "james", Person.class);
        ((Cache)this.caches.get(1)).put(this.key("C2"), (Object)new Car("megane", "blue", 300));
        this.checkIndex(2, "make", "megane", Car.class);
        ((Cache)this.caches.get(1)).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).put(this.key("C3"), (Object)new Car("megane", "blue", 300));
        this.checkIndex(2, "make", "megane", Car.class);
        this.rebuildIndexes();
        this.checkIndex(5, Person.class);
        this.checkIndex(3, Car.class);
        this.checkIndex(3, "make", "megane", Car.class);
        this.checkIndex(1, "name", "tony", Person.class);
        ((Cache)this.caches.get(1)).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).remove(this.key("C2"));
        ((Cache)this.caches.get(1)).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).remove(this.key("P3"));
        Assert.assertNull((Object)((Cache)this.caches.get(1)).get(this.key("P3")));
        Assert.assertNull((Object)((Cache)this.caches.get(1)).get(this.key("C2")));
        this.checkIndex(3, "make", "megane", Car.class);
        this.checkIndex(5, Person.class);
        this.rebuildIndexes();
        this.checkIndex(2, Car.class);
        this.checkIndex(2, "make", "megane", Car.class);
        this.checkIndex(4, Person.class);
    }

    protected void checkIndex(int expectedCount, String fieldName, String fieldValue, Class<?> entity) throws ParseException {
        Query q = new QueryParser(fieldName, (Analyzer)new StandardAnalyzer()).parse(fieldName + ":" + fieldValue);
        this.checkIndex(expectedCount, q, entity);
    }

    protected void checkIndex(int expectedCount, Class<?> entity) throws ParseException {
        this.checkIndex(expectedCount, (Query)new MatchAllDocsQuery(), entity);
    }

    private void checkIndex(int expectedCount, Query luceneQuery, Class<?> entity) throws ParseException {
        for (Cache cache : this.caches) {
            StaticTestingErrorHandler.assertAllGood(cache);
            SearchManager searchManager = Search.getSearchManager((Cache)cache);
            CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[]{entity});
            AssertJUnit.assertEquals((int)expectedCount, (int)cacheQuery.getResultSize());
        }
    }
}

