/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.backend.MergeTest")
public class MergeTest
extends MultipleCacheManagersTest {
    private static final String MERGE_FACTOR = "10";
    private static final int OBJECT_COUNT = 100000;
    private static final int NUMBER_OF_THREADS = 10;
    private static final boolean TX_ENABLED = false;
    Cache<Long, Person> cache1;
    Cache<Long, Person> cache2;

    public static void main(String[] args) throws Throwable {
        MergeTest c = new MergeTest();
        c.createBeforeClass();
        c.createBeforeMethod();
        c.testMergesWrites();
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = MergeTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.clustering().sync().replTimeout(120000L).indexing().index(Index.LOCAL).addProperty("default.directory_provider", "infinispan").addProperty("default.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("default.indexwriter.merge_factor", MERGE_FACTOR).addProperty("hibernate.search.default.worker.execution", "async").addProperty("default.indexwriter.merge_max_size", "1024").addProperty("default.indexwriter.ram_buffer_size", "256").addProperty("lucene_version", "LUCENE_CURRENT");
        List caches = this.createClusteredCaches(2, cacheCfg);
        this.cache1 = (Cache)caches.get(0);
        this.cache2 = (Cache)caches.get(1);
    }

    public void testMergesWrites() throws Exception {
        final long start = System.currentTimeMillis();
        final CountDownLatch waitFor = new CountDownLatch(1);
        final AtomicLong id = new AtomicLong(1L);
        ArrayList<Future> futures = new ArrayList<Future>();
        final Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            futures.add(this.fork(new Runnable(){

                @Override
                public void run() {
                    try {
                        waitFor.await();
                        Thread.sleep(random.nextInt(3000));
                        for (int j = 0; j < 100000; ++j) {
                            Cache<Long, Person> cache = j % 2 == 0 ? MergeTest.this.cache1 : MergeTest.this.cache2;
                            long key = id.incrementAndGet();
                            cache.put((Object)key, (Object)new Person("name" + key, "blurb", 30));
                            if (j % 100 != 0) continue;
                            System.out.println(j + " in " + (System.currentTimeMillis() - start) / 1000L + "s ");
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        waitFor.countDown();
        for (Future f : futures) {
            f.get();
        }
        StaticTestingErrorHandler.assertAllGood(this.cache1, this.cache2);
        System.out.println("Load took: " + (System.currentTimeMillis() - start) / 1000L + " s");
        SearchManager searchManager = Search.getSearchManager(this.cache1);
        final CacheQuery query = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Person.class});
        int total = 1000000;
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                return query.list().size() == 1000000;
            }
        });
        System.out.println("Indexing finished: " + query.list().size());
        TestingUtil.killCacheManagers((List)this.cacheManagers);
    }
}

