/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.hql.ParsingException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AddressHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.impl.QueryEngineTest")
@CleanupAfterTest
public class QueryEngineTest
extends MultipleCacheManagersTest {
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private QueryEngine qe;

    public QueryEngineTest() {
        this.DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private Date makeDate(String dateStr) throws ParseException {
        return this.DATE_FORMAT.parse(dateStr);
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(UserHS.class).addIndexedEntity(AccountHS.class).addIndexedEntity(TransactionHS.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(1, cfg);
    }

    @BeforeClass(alwaysRun=true)
    protected void init() throws Exception {
        this.qe = new QueryEngine(this.cache(0).getAdvancedCache(), true);
        UserHS user1 = new UserHS();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        AddressHS address1 = new AddressHS();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        user1.setAddresses(Collections.singletonList(address1));
        UserHS user2 = new UserHS();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAge(44);
        user2.setAccountIds(Collections.singleton(3));
        AddressHS address2 = new AddressHS();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        AddressHS address3 = new AddressHS();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        user2.setAddresses(Arrays.asList(address2, address3));
        UserHS user3 = new UserHS();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAccountIds(Collections.emptySet());
        AccountHS account1 = new AccountHS();
        account1.setId(1);
        account1.setDescription("John Doe's first bank account");
        account1.setCreationDate(this.makeDate("2013-01-03"));
        AccountHS account2 = new AccountHS();
        account2.setId(2);
        account2.setDescription("John Doe's second bank account");
        account2.setCreationDate(this.makeDate("2013-01-04"));
        AccountHS account3 = new AccountHS();
        account3.setId(3);
        account3.setCreationDate(this.makeDate("2013-01-20"));
        TransactionHS transaction0 = new TransactionHS();
        transaction0.setId(0);
        transaction0.setDescription("Birthday present");
        transaction0.setAccountId(1);
        transaction0.setAmount(1800.0);
        transaction0.setDate(this.makeDate("2012-09-07"));
        transaction0.setDebit(false);
        transaction0.setValid(true);
        TransactionHS transaction1 = new TransactionHS();
        transaction1.setId(1);
        transaction1.setDescription("Feb. rent payment");
        transaction1.setAccountId(1);
        transaction1.setAmount(1500.0);
        transaction1.setDate(this.makeDate("2013-01-05"));
        transaction1.setDebit(true);
        transaction1.setValid(true);
        TransactionHS transaction2 = new TransactionHS();
        transaction2.setId(2);
        transaction2.setDescription("Starbucks");
        transaction2.setAccountId(1);
        transaction2.setAmount(23.0);
        transaction2.setDate(this.makeDate("2013-01-09"));
        transaction2.setDebit(true);
        transaction2.setValid(true);
        TransactionHS transaction3 = new TransactionHS();
        transaction3.setId(3);
        transaction3.setDescription("Hotel");
        transaction3.setAccountId(2);
        transaction3.setAmount(45.0);
        transaction3.setDate(this.makeDate("2013-02-27"));
        transaction3.setDebit(true);
        transaction3.setValid(true);
        TransactionHS transaction4 = new TransactionHS();
        transaction4.setId(4);
        transaction4.setDescription("Last january");
        transaction4.setAccountId(2);
        transaction4.setAmount(95.0);
        transaction4.setDate(this.makeDate("2013-01-31"));
        transaction4.setDebit(true);
        transaction4.setValid(true);
        TransactionHS transaction5 = new TransactionHS();
        transaction5.setId(5);
        transaction5.setDescription("Popcorn");
        transaction5.setAccountId(2);
        transaction5.setAmount(5.0);
        transaction5.setDate(this.makeDate("2013-01-01"));
        transaction5.setDebit(true);
        transaction5.setValid(true);
        this.cache(0).put((Object)("user_" + user1.getId()), (Object)user1);
        this.cache(0).put((Object)("user_" + user2.getId()), (Object)user2);
        this.cache(0).put((Object)("user_" + user3.getId()), (Object)user3);
        this.cache(0).put((Object)("account_" + account1.getId()), (Object)account1);
        this.cache(0).put((Object)("account_" + account2.getId()), (Object)account2);
        this.cache(0).put((Object)("account_" + account3.getId()), (Object)account3);
        this.cache(0).put((Object)("transaction_" + transaction0.getId()), (Object)transaction0);
        this.cache(0).put((Object)("transaction_" + transaction1.getId()), (Object)transaction1);
        this.cache(0).put((Object)("transaction_" + transaction2.getId()), (Object)transaction2);
        this.cache(0).put((Object)("transaction_" + transaction3.getId()), (Object)transaction3);
        this.cache(0).put((Object)("transaction_" + transaction4.getId()), (Object)transaction4);
        this.cache(0).put((Object)("transaction_" + transaction5.getId()), (Object)transaction5);
        for (int i = 0; i < 50; ++i) {
            TransactionHS transaction = new TransactionHS();
            transaction.setId(50 + i);
            transaction.setDescription("Expensive shoes " + i);
            transaction.setAccountId(2);
            transaction.setAmount(100 + i);
            transaction.setDate(this.makeDate("2013-08-20"));
            transaction.setDebit(true);
            transaction.setValid(true);
            this.cache(0).put((Object)("transaction_" + transaction.getId()), (Object)transaction);
        }
        this.cache(0).put((Object)"dummy", (Object)"a primitive value cannot be queried");
        this.cache(0).put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        this.cache(0).put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
    }

    protected void clearContent() {
    }

    public void testGrouping() {
        BaseQuery q = this.qe.buildQuery(null, "select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS where surname is not null group by name having name >= 'A'", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    public void testNoGroupingOrAggregation() {
        BaseQuery q = this.qe.buildQuery(null, "from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="HQL000008: Cannot have aggregate functions in GROUP BY clause : SUM.")
    public void testDisallowAggregationInGroupBy() {
        BaseQuery q = this.qe.buildQuery(null, "select sum(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by sum(age) ", null, -1L, -1);
        q.list();
    }

    public void testDuplicatesAcceptedInGroupBy() {
        BaseQuery q = this.qe.buildQuery(null, "select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name, name", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
    }

    public void testDuplicatesAcceptedInSelect1() {
        BaseQuery q = this.qe.buildQuery(null, "select name, name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
    }

    public void testDuplicatesAcceptedInSelect2() {
        BaseQuery q = this.qe.buildQuery(null, "select max(name), max(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
    }

    public void testDuplicatesAcceptedInSelect3() {
        BaseQuery q = this.qe.buildQuery(null, "select min(name), max(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
    }

    public void testDuplicatesAcceptedInOrderBy1() {
        BaseQuery q = this.qe.buildQuery(null, "from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS order by age, age", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testDuplicatesAcceptedInOrderBy2() {
        BaseQuery q = this.qe.buildQuery(null, "from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS order by age, name, age", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014024: The property path 'addresses.postCode' cannot be used in the ORDER BY clause because it is multi-valued")
    public void testRejectMultivaluedOrderBy() {
        BaseQuery q = this.qe.buildQuery(null, "from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u order by u.addresses.postCode", null, -1L, -1);
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014023: Using the multi-valued property path 'addresses.postCode' in the GROUP BY clause is not currently supported")
    public void testRejectMultivaluedGroupBy() {
        BaseQuery q = this.qe.buildQuery(null, "select u.addresses.postCode from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u group by u.addresses.postCode", null, -1L, -1);
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'age' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testMissingAggregateInSelect() {
        BaseQuery q = this.qe.buildQuery(null, "select age from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name", null, -1L, -1);
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'age' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testMissingAggregateInOrderBy() {
        BaseQuery q = this.qe.buildQuery(null, "select name, sum(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name order by age", null, -1L, -1);
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="HQL000009: Cannot have aggregate functions in WHERE clause : SUM.")
    public void testDisallowAggregatesInWhereClause() {
        BaseQuery q = this.qe.buildQuery(null, "select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS where sum(age) > 33 group by name", null, -1L, -1);
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'age' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testHavingClauseAllowsAggregationsAndGroupByColumnsOnly() {
        BaseQuery q = this.qe.buildQuery(null, "select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name having age >= 18", null, -1L, -1);
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'name' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testDisallowNonAggregatedProjectionWithGlobalAggregation() {
        BaseQuery q = this.qe.buildQuery(null, "select name, count(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        q.list();
    }

    public void testBuildLuceneQuery() {
        CacheQuery q = this.qe.buildLuceneQuery("select name from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="HQL100002: The type org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS has no indexed property named notes.")
    public void testBuildLuceneQueryOnNonIndexedField() {
        CacheQuery q = this.qe.buildLuceneQuery("select notes from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
    }

    public void testGlobalCount() {
        BaseQuery q = this.qe.buildQuery(null, "select count(name), count(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)3L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)2L, (Object)((Object[])list.get(0))[1]);
    }

    public void testGlobalAvg() {
        BaseQuery q = this.qe.buildQuery(null, "select avg(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)33.0, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalSum() {
        BaseQuery q = this.qe.buildQuery(null, "select sum(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)66L, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalMin() {
        BaseQuery q = this.qe.buildQuery(null, "select min(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalMax() {
        BaseQuery q = this.qe.buildQuery(null, "select max(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)44, (Object)((Object[])list.get(0))[0]);
    }

    public void testAggregateGroupingField() {
        BaseQuery q = this.qe.buildQuery(null, "select count(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name order by count(name)", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)2L, (Object)((Object[])list.get(1))[0]);
    }

    public void testAggregateEmbedded1() {
        BaseQuery q = this.qe.buildQuery(null, "select max(accountIds) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS group by name order by name", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(1))[0]);
    }

    public void testAggregateEmbedded2() {
        BaseQuery q = this.qe.buildQuery(null, "select max(u.addresses.postCode) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u group by u.name order by u.name", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"ZZ", (Object)((Object[])list.get(1))[0]);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Aggregation SUM cannot be applied to property of type java.lang.String")
    public void testIncompatibleAggregator() {
        BaseQuery q = this.qe.buildQuery(null, "select sum(name) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS", null, -1L, -1);
        q.list();
    }

    public void testAggregateNulls() {
        BaseQuery q = this.qe.buildQuery(null, "select name, sum(age), avg(age) from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS where surname is not null group by name having name >= 'A' and count(age) >= 1", null, -1L, -1);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
    }
}

