/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.externalizers;

import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.externalizers.TermExternalizerTest")
public class TermExternalizerTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalCfg1 = this.createForeignExternalizerGlobalConfig();
        GlobalConfigurationBuilder globalCfg2 = this.createForeignExternalizerGlobalConfig();
        ConfigurationBuilder cfg = TermExternalizerTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalCfg1, (ConfigurationBuilder)cfg);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalCfg2, (ConfigurationBuilder)cfg);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        this.defineConfigurationOnAllManagers(this.getCacheName(), cfg);
        this.waitForClusterToForm(this.getCacheName());
    }

    protected String getCacheName() {
        return "QueryExternalizers-LuceneTerm";
    }

    protected GlobalConfigurationBuilder createForeignExternalizerGlobalConfig() {
        return new GlobalConfigurationBuilder().clusteredDefault();
    }

    public void emptyPayloadTest() {
        BytesRef payload = new BytesRef();
        Term t = new Term("hello terms world!", payload);
        this.assertMarshallable(t);
    }

    public void somePayloadTest() {
        BytesRef payload = new BytesRef(new byte[]{0, 7, 3});
        Term t = new Term("hello terms world!", payload);
        this.assertMarshallable(t);
    }

    public void offsetPayloadTest() {
        BytesRef payload = new BytesRef(new byte[]{0, 7, 3}, 1, 2);
        Term t = new Term("hello terms world!", payload);
        this.assertMarshallable(t);
    }

    public void offsetLimitedPayloadTest() {
        BytesRef payload = new BytesRef(new byte[]{0, 7, 3, 2, 2, 7}, 1, 2);
        Term t = new Term("hello terms world!", payload);
        this.assertMarshallable(t);
    }

    private void assertMarshallable(Term obj) {
        Cache cache1 = this.manager(0).getCache(this.getCacheName());
        Cache cache2 = this.manager(1).getCache(this.getCacheName());
        cache1.put((Object)"key", (Object)obj);
        Term beamedUpObject = (Term)cache2.get((Object)"key");
        Assert.assertEquals((Object)obj, (Object)beamedUpObject);
        Assert.assertEquals((Object)obj.field(), (Object)beamedUpObject.field());
        Assert.assertEquals((Object)obj.text(), (Object)beamedUpObject.text());
        BytesRef referencePayload = obj.bytes();
        BytesRef clonedPayload = beamedUpObject.bytes();
        Assert.assertEquals((Object)referencePayload, (Object)clonedPayload);
        Assert.assertEquals((Object)obj.toString(), (Object)beamedUpObject.toString());
    }
}

