/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.ResultProcessor;
import org.infinispan.query.dsl.embedded.impl.RowProcessor;
import org.infinispan.query.dsl.impl.BaseQuery;

final class EmbeddedLuceneQuery
extends BaseQuery {
    private final QueryEngine queryEngine;
    private final ResultProcessor resultProcessor;
    private final FilterParsingResult<?> parsingResult;
    private CacheQuery cacheQuery;
    private List<Object> results;

    EmbeddedLuceneQuery(QueryEngine queryEngine, QueryFactory queryFactory, Map<String, Object> namedParameters, FilterParsingResult<?> parsingResult, String[] projection, ResultProcessor resultProcessor, long startOffset, int maxResults) {
        super(queryFactory, parsingResult.getJpaQuery(), namedParameters, projection, startOffset, maxResults);
        if (resultProcessor instanceof RowProcessor && (projection == null || projection.length == 0)) {
            throw new IllegalArgumentException("A RowProcessor can only be specified with projections");
        }
        this.queryEngine = queryEngine;
        this.resultProcessor = resultProcessor;
        this.parsingResult = parsingResult;
    }

    public void resetQuery() {
        this.results = null;
        this.cacheQuery = null;
    }

    private CacheQuery createCacheQuery() {
        if (this.cacheQuery == null) {
            this.cacheQuery = this.queryEngine.buildLuceneQuery(this.parsingResult, this.namedParameters, this.startOffset, this.maxResults);
        }
        return this.cacheQuery;
    }

    public <T> List<T> list() {
        if (this.results == null) {
            this.results = this.listInternal();
        }
        return this.results;
    }

    private List<Object> listInternal() {
        List<Object> list = this.createCacheQuery().list();
        if (this.resultProcessor != null) {
            this.results = new ArrayList<Object>(list.size());
            list.forEach(r -> this.results.add(this.resultProcessor.process(r)));
        } else {
            this.results = list;
        }
        return this.results;
    }

    public int getResultSize() {
        return this.createCacheQuery().getResultSize();
    }

    public String toString() {
        return "EmbeddedLuceneQuery{jpaQuery=" + this.jpaQuery + ", namedParameters=" + this.namedParameters + '}';
    }
}

