/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.Util;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.objectfilter.impl.RowMatcher;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.hql.RowPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.ExprVisitor;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.JPATreePrinter;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.AggregatingQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.EmptyResultQuery;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchIndexedFieldProvider;
import org.infinispan.query.dsl.embedded.impl.HybridQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.embedded.impl.ResultProcessor;
import org.infinispan.query.dsl.embedded.impl.RowProcessor;
import org.infinispan.query.dsl.embedded.impl.SecurityActions;
import org.infinispan.query.dsl.embedded.impl.jpalucene.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.jpalucene.JPALuceneTransformer;
import org.infinispan.query.dsl.embedded.impl.jpalucene.LuceneQueryParsingResult;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.logging.Log;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

public class QueryEngine {
    private static final Log log = (Log)LogFactory.getLog(QueryEngine.class, Log.class);
    private static final int MAX_EXPANSION_COFACTORS = 16;
    private final AuthorizationManager authorizationManager;
    protected final AdvancedCache<?, ?> cache;
    protected final boolean isIndexed;
    private final QueryCache queryCache;
    private SearchManager searchManager;
    private SearchIntegrator searchFactory;
    private final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();

    public QueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed) {
        this.cache = cache;
        this.isIndexed = isIndexed;
        this.queryCache = ComponentRegistryUtils.getQueryCache(cache);
        this.authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
    }

    private SearchManager getSearchManager() {
        if (!this.isIndexed) {
            throw new IllegalStateException("Cache is not indexed");
        }
        if (this.searchManager == null) {
            this.searchManager = Search.getSearchManager(this.cache);
        }
        return this.searchManager;
    }

    protected SearchIntegrator getSearchFactory() {
        if (this.searchFactory == null) {
            this.searchFactory = this.getSearchManager().unwrap(SearchIntegrator.class);
        }
        return this.searchFactory;
    }

    public BaseQuery buildQuery(QueryFactory queryFactory, String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults) {
        if (this.authorizationManager != null) {
            this.authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
        this.checkParameters(namedParameters);
        FilterParsingResult<?> parsingResult = this.parse(jpqlString);
        if (parsingResult.hasGroupingOrAggregations()) {
            return this.buildQueryWithAggregations(queryFactory, jpqlString, namedParameters, startOffset, maxResults, parsingResult);
        }
        return this.buildQueryNoAggregations(queryFactory, jpqlString, namedParameters, startOffset, maxResults, parsingResult);
    }

    private void checkParameters(Map<String, Object> namedParameters) {
        if (namedParameters != null) {
            for (Map.Entry<String, Object> e : namedParameters.entrySet()) {
                if (e.getValue() != null) continue;
                throw log.queryParameterNotSet(e.getKey());
            }
        }
    }

    private BaseQuery buildQueryWithAggregations(QueryFactory queryFactory, String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults, FilterParsingResult<?> parsingResult) {
        int idx;
        Class propertyType;
        if (parsingResult.getProjectedPaths() == null) {
            throw log.groupingAndAggregationQueriesMustUseProjections();
        }
        LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns = new LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata>();
        ObjectPropertyHelper propertyHelper = this.getMatcher().getPropertyHelper();
        if (parsingResult.getGroupBy() != null) {
            for (PropertyPath p : parsingResult.getGroupBy()) {
                if (p.getAggregationType() != null) {
                    throw log.cannotHaveAggregationsInGroupByClause();
                }
                if (columns.containsKey(p)) continue;
                if (propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityName(), p.getPath())) {
                    throw log.multivaluedPropertyCannotBeUsedInGroupBy(p.toString());
                }
                propertyType = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
                idx = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
            }
        }
        int noOfGroupingColumns = columns.size();
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
            if (p.getAggregationType() == null && (c == null || c.getColumnIndex() >= noOfGroupingColumns)) {
                throw log.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
            }
            if (c != null) continue;
            propertyType = parsingResult.getProjectedTypes()[i];
            idx = columns.size();
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath p = sortField.getPath();
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (p.getAggregationType() == null && (c == null || c.getColumnIndex() >= noOfGroupingColumns)) {
                    throw log.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
                }
                if (c != null) continue;
                Class propertyType2 = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
                int idx2 = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx2, "C" + idx2, propertyType2));
            }
        }
        String havingClause = null;
        if (parsingResult.getHavingClause() != null) {
            BooleanExpr normalizedHavingClause = this.booleanFilterNormalizer.normalize(parsingResult.getHavingClause());
            if (normalizedHavingClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, jpqlString, namedParameters, startOffset, maxResults);
            }
            if (normalizedHavingClause != ConstantBooleanExpr.TRUE) {
                havingClause = JPATreePrinter.printTree((BooleanExpr)this.swapVariables(normalizedHavingClause, parsingResult.getTargetEntityName(), columns));
            }
        }
        for (PropertyPath p : columns.keySet()) {
            if (!propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityName(), p.getPath())) continue;
            return this.buildQueryWithRepeatedAggregations(queryFactory, jpqlString, namedParameters, startOffset, maxResults, parsingResult, havingClause, columns, noOfGroupingColumns);
        }
        LinkedHashMap<String, Integer> inColumns = new LinkedHashMap<String, Integer>();
        LinkedList<FieldAccumulator> accumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            _columns[c.getColumnIndex()] = c;
            String asStringPath = p.asStringPath();
            Integer inIdx = (Integer)inColumns.get(asStringPath);
            if (inIdx == null) {
                inIdx = inColumns.size();
                inColumns.put(asStringPath, inIdx);
            }
            if (p.getAggregationType() == null) continue;
            FieldAccumulator acc = FieldAccumulator.makeAccumulator((PropertyPath.AggregationType)p.getAggregationType(), (int)inIdx, (int)c.getColumnIndex(), (Class)c.getPropertyType());
            accumulators.add(acc);
        }
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("SELECT ");
        boolean isFirst = true;
        for (String p : inColumns.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                firstPhaseQuery.append(", ");
            }
            firstPhaseQuery.append("_gen0").append('.').append(p);
        }
        firstPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = this.booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, jpqlString, namedParameters, startOffset, maxResults);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(JPATreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                secondPhaseQuery.append(", ");
            }
            secondPhaseQuery.append(c.getColumnName());
        }
        secondPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            secondPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            secondPhaseQuery.append(" ORDER BY ");
            boolean isFirst2 = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst2) {
                    isFirst2 = false;
                } else {
                    secondPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                secondPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, namedParameters, -1L, -1, this.parse(firstPhaseQueryStr));
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, secondPhaseQueryStr, namedParameters, noOfGroupingColumns, accumulators, false, this.getObjectFilter((BaseMatcher)new RowMatcher(_columns), secondPhaseQueryStr, namedParameters, null), startOffset, maxResults, baseQuery);
    }

    private BooleanExpr swapVariables(BooleanExpr expr, final String targetEntityName, final LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns) {
        final ObjectPropertyHelper propertyHelper = this.getMatcher().getPropertyHelper();
        class PropertyReplacer
        extends ExprVisitor {
            PropertyReplacer() {
            }

            public BooleanExpr visit(NotExpr notExpr) {
                return new NotExpr((BooleanExpr)notExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(OrExpr orExpr) {
                ArrayList<Object> visitedChildren = new ArrayList<Object>();
                for (BooleanExpr c : orExpr.getChildren()) {
                    visitedChildren.add(c.acceptVisitor((Visitor)this));
                }
                return new OrExpr(visitedChildren);
            }

            public BooleanExpr visit(AndExpr andExpr) {
                ArrayList<Object> visitedChildren = new ArrayList<Object>();
                for (BooleanExpr c : andExpr.getChildren()) {
                    visitedChildren.add(c.acceptVisitor((Visitor)this));
                }
                return new AndExpr(visitedChildren);
            }

            public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
                return constantBooleanExpr;
            }

            public BooleanExpr visit(IsNullExpr isNullExpr) {
                return new IsNullExpr((ValueExpr)isNullExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(ComparisonExpr comparisonExpr) {
                return new ComparisonExpr((ValueExpr)comparisonExpr.getLeftChild().acceptVisitor((Visitor)this), comparisonExpr.getRightChild(), comparisonExpr.getComparisonType());
            }

            public BooleanExpr visit(LikeExpr likeExpr) {
                return new LikeExpr((ValueExpr)likeExpr.getChild().acceptVisitor((Visitor)this), likeExpr.getPattern());
            }

            public ValueExpr visit(ConstantValueExpr constantValueExpr) {
                return constantValueExpr;
            }

            public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
                PropertyPath p = new PropertyPath(null, propertyValueExpr.getPropertyPath());
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (c == null) {
                    throw log.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(propertyValueExpr.toJpaString());
                }
                return new PropertyValueExpr(c.getColumnName(), propertyValueExpr.isRepeated(), propertyValueExpr.getPrimitiveType());
            }

            public ValueExpr visit(AggregationExpr aggregationExpr) {
                PropertyPath p = new PropertyPath(aggregationExpr.getAggregationType(), aggregationExpr.getPropertyPath());
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (c == null) {
                    Class propertyType = propertyHelper.getPrimitivePropertyType(targetEntityName, aggregationExpr.getPropertyPath());
                    propertyType = FieldAccumulator.getOutputType((PropertyPath.AggregationType)aggregationExpr.getAggregationType(), (Class)propertyType);
                    int idx = columns.size();
                    c = new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType);
                    columns.put(p, c);
                }
                return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated(), aggregationExpr.getPrimitiveType());
            }
        }
        return (BooleanExpr)expr.acceptVisitor((Visitor)new PropertyReplacer());
    }

    private BaseQuery buildQueryWithRepeatedAggregations(QueryFactory queryFactory, String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults, FilterParsingResult<?> parsingResult, String havingClause, LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns, int noOfGroupingColumns) {
        ObjectPropertyHelper propertyHelper = this.getMatcher().getPropertyHelper();
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = this.booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, jpqlString, namedParameters, startOffset, maxResults);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(JPATreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, namedParameters, -1L, -1, this.parse(firstPhaseQueryStr));
        LinkedList<FieldAccumulator> secondPhaseAccumulators = new LinkedList<FieldAccumulator>();
        LinkedList<FieldAccumulator> thirdPhaseAccumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (c.getColumnIndex() > 0) {
                secondPhaseQuery.append(", ");
            }
            if (p.getAggregationType() != null) {
                FieldAccumulator acc = FieldAccumulator.makeAccumulator((PropertyPath.AggregationType)p.getAggregationType(), (int)c.getColumnIndex(), (int)c.getColumnIndex(), (Class)c.getPropertyType());
                if (propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityName(), p.getPath())) {
                    secondPhaseAccumulators.add(acc);
                    if (p.getAggregationType() == PropertyPath.AggregationType.COUNT) {
                        c = new RowPropertyHelper.ColumnMetadata(c.getColumnIndex(), c.getColumnName(), Long.class);
                        acc = FieldAccumulator.makeAccumulator((PropertyPath.AggregationType)PropertyPath.AggregationType.SUM, (int)c.getColumnIndex(), (int)c.getColumnIndex(), Long.class);
                    }
                } else {
                    secondPhaseAccumulators.add(null);
                }
                thirdPhaseAccumulators.add(acc);
            } else {
                secondPhaseAccumulators.add(null);
            }
            secondPhaseQuery.append("_gen0").append('.').append(p.asStringPath());
            _columns[c.getColumnIndex()] = c;
        }
        secondPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        HybridQuery projectingAggregatingQuery = new HybridQuery(queryFactory, this.cache, secondPhaseQueryStr, namedParameters, this.getObjectFilter(this.getMatcher(), secondPhaseQueryStr, namedParameters, secondPhaseAccumulators), -1L, -1, (Query)baseQuery);
        StringBuilder thirdPhaseQuery = new StringBuilder();
        thirdPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                thirdPhaseQuery.append(", ");
            }
            thirdPhaseQuery.append(c.getColumnName());
        }
        thirdPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            thirdPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            thirdPhaseQuery.append(" ORDER BY ");
            boolean isFirst = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    thirdPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                thirdPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String thirdPhaseQueryStr = thirdPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, thirdPhaseQueryStr, namedParameters, noOfGroupingColumns, thirdPhaseAccumulators, true, this.getObjectFilter((BaseMatcher)new RowMatcher(_columns), thirdPhaseQueryStr, namedParameters, null), startOffset, maxResults, projectingAggregatingQuery);
    }

    /*
     * WARNING - void declaration
     */
    private BaseQuery buildQueryNoAggregations(QueryFactory queryFactory, String jpqlString, Map<String, Object> namedParameters, long startOffset, int maxResults, FilterParsingResult<?> parsingResult) {
        BooleShannonExpansion bse;
        BooleanExpr expansion;
        BooleanExpr normalizedWhereClause;
        if (parsingResult.hasGroupingOrAggregations()) {
            throw log.queryMustNotUseGroupingOrAggregation();
        }
        ObjectPropertyHelper propertyHelper = this.getMatcher().getPropertyHelper();
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath p = sortField.getPath();
                if (!propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityName(), p.getPath())) continue;
                throw log.multivaluedPropertyCannotBeUsedInOrderBy(p.toString());
            }
        }
        if (parsingResult.getProjectedPaths() != null) {
            for (SortField sortField : parsingResult.getProjectedPaths()) {
                if (!propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityName(), sortField.getPath())) continue;
                throw log.multivaluedPropertyCannotBeProjected(sortField.asStringPath());
            }
        }
        if ((normalizedWhereClause = this.booleanFilterNormalizer.normalize(parsingResult.getWhereClause())) == ConstantBooleanExpr.FALSE) {
            return new EmptyResultQuery(queryFactory, this.cache, jpqlString, namedParameters, startOffset, maxResults);
        }
        if (normalizedWhereClause == null || normalizedWhereClause == ConstantBooleanExpr.TRUE || !this.isIndexed) {
            return new EmbeddedQuery(this, queryFactory, this.cache, jpqlString, namedParameters, parsingResult.getProjections(), startOffset, maxResults);
        }
        BooleShannonExpansion.IndexedFieldProvider indexedFieldProvider = this.getIndexedFieldProvider(parsingResult);
        boolean allProjectionsAreStored = true;
        Object var12_15 = null;
        if (parsingResult.getProjectedPaths() != null) {
            LinkedHashMap<PropertyPath, ArrayList<Integer>> linkedHashMap = new LinkedHashMap<PropertyPath, ArrayList<Integer>>();
            for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
                PropertyPath p = parsingResult.getProjectedPaths()[i];
                ArrayList<Integer> idx = (ArrayList<Integer>)linkedHashMap.get(p);
                if (idx == null) {
                    idx = new ArrayList<Integer>();
                    linkedHashMap.put(p, idx);
                    if (!indexedFieldProvider.isStored(p.getPath())) {
                        allProjectionsAreStored = false;
                    }
                }
                idx.add(i);
            }
        }
        boolean allSortFieldsAreStored = true;
        SortField[] sortFields = parsingResult.getSortFields();
        if (sortFields != null) {
            LinkedHashMap<String, SortField> sortFieldMap = new LinkedHashMap<String, SortField>();
            for (SortField sf : sortFields) {
                PropertyPath p = sf.getPath();
                String asStringPath = p.asStringPath();
                if (sortFieldMap.containsKey(asStringPath)) continue;
                sortFieldMap.put(asStringPath, sf);
                if (indexedFieldProvider.isStored(p.getPath())) continue;
                allSortFieldsAreStored = false;
            }
            sortFields = sortFieldMap.values().toArray(new SortField[sortFieldMap.size()]);
        }
        if ((expansion = (bse = new BooleShannonExpansion(16, indexedFieldProvider)).expand(normalizedWhereClause)) == normalizedWhereClause) {
            String projectionQueryStr;
            if (allSortFieldsAreStored) {
                if (allProjectionsAreStored) {
                    RowProcessor rowProcessor = null;
                    if (parsingResult.getProjectedPaths() != null) {
                        void var12_17;
                        if (var12_17.size() != parsingResult.getProjectedPaths().length) {
                            Class[] projectedTypes = new Class[var12_17.size()];
                            int[] map = new int[parsingResult.getProjectedPaths().length];
                            int j = 0;
                            for (List idx : var12_17.values()) {
                                int i = (Integer)idx.get(0);
                                projectedTypes[j] = parsingResult.getProjectedTypes()[i];
                                Iterator iterator = idx.iterator();
                                while (iterator.hasNext()) {
                                    int k = (Integer)iterator.next();
                                    map[k] = j;
                                }
                                ++j;
                            }
                            RowProcessor projectionProcessor = this.makeProjectionProcessor(projectedTypes);
                            rowProcessor = inRow -> {
                                if (projectionProcessor != null) {
                                    inRow = projectionProcessor.process(inRow);
                                }
                                Object[] outRow = new Object[map.length];
                                for (int i = 0; i < map.length; ++i) {
                                    outRow[i] = inRow[map[i]];
                                }
                                return outRow;
                            };
                            PropertyPath[] deduplicatedProjection = var12_17.keySet().toArray(new PropertyPath[var12_17.size()]);
                            FilterParsingResult<?> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, deduplicatedProjection, projectedTypes, sortFields);
                            return new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, parsingResult.getProjections(), this.makeResultProcessor(rowProcessor), startOffset, maxResults);
                        }
                        rowProcessor = this.makeProjectionProcessor(parsingResult.getProjectedTypes());
                    }
                    return new EmbeddedLuceneQuery(this, queryFactory, namedParameters, parsingResult, parsingResult.getProjections(), this.makeResultProcessor(rowProcessor), startOffset, maxResults);
                }
                FilterParsingResult<?> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, null, null, sortFields);
                EmbeddedLuceneQuery indexQuery = new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, null, this.makeResultProcessor(null), startOffset, maxResults);
                projectionQueryStr = JPATreePrinter.printTree((String)parsingResult.getTargetEntityName(), (PropertyPath[])parsingResult.getProjectedPaths(), null, null);
                return new HybridQuery(queryFactory, this.cache, projectionQueryStr, null, this.getObjectFilter(this.getMatcher(), projectionQueryStr, null, null), -1L, -1, (Query)indexQuery);
            }
            FilterParsingResult<?> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, null, null, null);
            EmbeddedLuceneQuery indexQuery = new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, null, this.makeResultProcessor(null), -1L, -1);
            projectionQueryStr = JPATreePrinter.printTree((String)parsingResult.getTargetEntityName(), (PropertyPath[])parsingResult.getProjectedPaths(), null, (SortField[])sortFields);
            return new HybridQuery(queryFactory, this.cache, projectionQueryStr, null, this.getObjectFilter(this.getMatcher(), projectionQueryStr, null, null), startOffset, maxResults, (Query)indexQuery);
        }
        if (expansion == ConstantBooleanExpr.TRUE) {
            return new EmbeddedQuery(this, queryFactory, this.cache, jpqlString, namedParameters, parsingResult.getProjections(), startOffset, maxResults);
        }
        FilterParsingResult<?> fpr = this.makeFilterParsingResult(parsingResult, expansion, null, null, null);
        EmbeddedLuceneQuery expandedQuery = new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, null, this.makeResultProcessor(null), -1L, -1);
        return new HybridQuery(queryFactory, this.cache, jpqlString, namedParameters, this.getObjectFilter(this.getMatcher(), jpqlString, namedParameters, null), startOffset, maxResults, (Query)expandedQuery);
    }

    private FilterParsingResult<?> makeFilterParsingResult(FilterParsingResult<?> parsingResult, BooleanExpr normalizedWhereClause, PropertyPath[] projection, Class<?>[] projectedTypes, SortField[] sortFields) {
        String jpaQuery = JPATreePrinter.printTree((String)parsingResult.getTargetEntityName(), (PropertyPath[])projection, (BooleanExpr)normalizedWhereClause, (SortField[])sortFields);
        return new FilterParsingResult(jpaQuery, parsingResult.getParameterNames(), normalizedWhereClause, null, parsingResult.getTargetEntityName(), parsingResult.getTargetEntityMetadata(), projection, (Class[])projectedTypes, null, sortFields);
    }

    protected ResultProcessor makeResultProcessor(ResultProcessor in) {
        return in;
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes) {
        return null;
    }

    protected BaseMatcher getMatcher() {
        return (BaseMatcher)SecurityActions.getCacheComponentRegistry(this.cache).getComponent(ReflectionMatcher.class);
    }

    private FilterParsingResult<?> parse(String jpqlString) {
        FilterParsingResult parsingResult;
        if (this.queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, FilterParsingResult.class);
            parsingResult = (FilterParsingResult)this.queryCache.get(queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.getMatcher().getParser().parse(jpqlString);
                this.queryCache.put(queryCacheKey, parsingResult);
            }
        } else {
            parsingResult = this.getMatcher().getParser().parse(jpqlString);
        }
        return parsingResult;
    }

    private ObjectFilter getObjectFilter(BaseMatcher matcher, String jpqlString, Map<String, Object> namedParameters, List<FieldAccumulator> acc) {
        ObjectFilter objectFilter;
        if (this.queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, (Object)new KeyValuePair(matcher.getClass(), acc));
            objectFilter = (ObjectFilter)this.queryCache.get(queryCacheKey);
            if (objectFilter == null) {
                objectFilter = matcher.getObjectFilter(jpqlString, acc);
                this.queryCache.put(queryCacheKey, objectFilter);
            }
        } else {
            objectFilter = matcher.getObjectFilter(jpqlString, acc);
        }
        return namedParameters != null ? objectFilter.withParameters(namedParameters) : objectFilter;
    }

    protected BooleShannonExpansion.IndexedFieldProvider getIndexedFieldProvider(FilterParsingResult<?> parsingResult) {
        return new HibernateSearchIndexedFieldProvider(this.getSearchFactory(), (Class)parsingResult.getTargetEntityMetadata());
    }

    protected JPAFilterAndConverter makeFilter(String jpaQuery, Map<String, Object> namedParameters) {
        JPAFilterAndConverter filter = this.createFilter(jpaQuery, namedParameters);
        SecurityActions.doPrivileged(() -> {
            this.cache.getComponentRegistry().wireDependencies((Object)filter);
            return null;
        });
        return filter;
    }

    protected JPAFilterAndConverter createFilter(String jpaQuery, Map<String, Object> namedParameters) {
        return new JPAFilterAndConverter(jpaQuery, namedParameters, ReflectionMatcher.class);
    }

    protected CacheQuery buildLuceneQuery(FilterParsingResult<?> filterParsingResult, Map<String, Object> namedParameters, long startOffset, int maxResults) {
        if (!this.isIndexed) {
            throw log.cannotRunLuceneQueriesIfNotIndexed();
        }
        this.checkParameters(namedParameters);
        LuceneQueryParsingResult<?> luceneParsingResult = this.transform(filterParsingResult, namedParameters);
        org.apache.lucene.search.Query luceneQuery = this.makeTypeQuery(luceneParsingResult.getQuery(), luceneParsingResult.getTargetEntityName());
        CacheQuery cacheQuery = this.getSearchManager().getQuery(luceneQuery, this.getTargetedClass(luceneParsingResult));
        if (luceneParsingResult.getSort() != null) {
            cacheQuery = cacheQuery.sort(luceneParsingResult.getSort());
        }
        if (luceneParsingResult.getProjections() != null) {
            cacheQuery = cacheQuery.projection(luceneParsingResult.getProjections());
        }
        if (startOffset >= 0L) {
            cacheQuery = cacheQuery.firstResult((int)startOffset);
        }
        if (maxResults > 0) {
            cacheQuery = cacheQuery.maxResults(maxResults);
        }
        return cacheQuery;
    }

    protected org.apache.lucene.search.Query makeTypeQuery(org.apache.lucene.search.Query query, String targetEntityName) {
        return query;
    }

    protected Class<?> getTargetedClass(LuceneQueryParsingResult<?> parsingResult) {
        return (Class)parsingResult.getTargetEntityMetadata();
    }

    protected LuceneQueryParsingResult<?> transform(FilterParsingResult<?> parsingResult, Map<String, Object> namedParameters) {
        EntityNamesResolver entityNamesResolver = entityName -> {
            try {
                return Util.loadClassStrict((String)entityName, null);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        };
        HibernateSearchPropertyHelper propertyHelper = new HibernateSearchPropertyHelper(this.getSearchFactory(), entityNamesResolver, null);
        return JPALuceneTransformer.transform(parsingResult, this.getSearchFactory(), entityNamesResolver, propertyHelper::getDefaultFieldBridge, namedParameters);
    }
}

