/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl.jpalucene;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Field;
import org.hibernate.hql.ParsingException;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.StringEncodingDateBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.jpalucene.JPALuceneTransformer;
import org.infinispan.query.logging.Log;
import org.jboss.logging.Logger;

public class HibernateSearchPropertyHelper
extends ObjectPropertyHelper<Class<?>> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)HibernateSearchPropertyHelper.class.getName());
    private final SearchIntegrator searchFactory;
    private final JPALuceneTransformer.FieldBridgeProvider fieldBridgeProvider;

    public HibernateSearchPropertyHelper(SearchIntegrator searchFactory, EntityNamesResolver entityNamesResolver, JPALuceneTransformer.FieldBridgeProvider fieldBridgeProvider) {
        super(entityNamesResolver);
        this.searchFactory = searchFactory;
        this.fieldBridgeProvider = fieldBridgeProvider;
    }

    public Class<?> getEntityMetadata(String targetTypeName) {
        return this.entityNamesResolver.getClassFromName(targetTypeName);
    }

    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        String[] path = propertyPath.toArray(new String[propertyPath.size()]);
        FieldBridge bridge = this.getFieldBridge(entityType, path);
        return this.convertToPropertyType(value, bridge);
    }

    public Class<?> getPrimitivePropertyType(String entityType, String[] propertyPath) {
        return null;
    }

    public boolean isRepeatedProperty(String entityType, String[] propertyPath) {
        return false;
    }

    private Object convertToPropertyType(String value, FieldBridge bridge) {
        try {
            if (bridge instanceof NullEncodingTwoWayFieldBridge) {
                return this.convertToPropertyType(value, (FieldBridge)((NullEncodingTwoWayFieldBridge)bridge).unwrap());
            }
            if (bridge instanceof TwoWayString2FieldBridgeAdaptor) {
                return ((TwoWayString2FieldBridgeAdaptor)bridge).unwrap().stringToObject(value);
            }
            if (bridge instanceof TwoWayStringBridge) {
                return ((TwoWayStringBridge)bridge).stringToObject(value);
            }
            if (bridge instanceof NumericFieldBridge) {
                switch ((NumericFieldBridge)bridge) {
                    case INT_FIELD_BRIDGE: {
                        return Integer.valueOf(value);
                    }
                    case LONG_FIELD_BRIDGE: {
                        return Long.valueOf(value);
                    }
                    case FLOAT_FIELD_BRIDGE: {
                        return Float.valueOf(value);
                    }
                    case DOUBLE_FIELD_BRIDGE: {
                        return Double.valueOf(value);
                    }
                }
                return value;
            }
            if (bridge instanceof StringEncodingCalendarBridge || bridge instanceof NumericEncodingCalendarBridge) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateTools.stringToDate((String)value));
                return calendar;
            }
            if (bridge instanceof StringEncodingDateBridge || bridge instanceof NumericEncodingDateBridge) {
                return DateTools.stringToDate((String)value);
            }
            return value;
        }
        catch (ParseException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    private FieldBridge getFieldBridge(String entityType, String[] propertyPath) {
        return this.fieldBridgeProvider != null ? this.fieldBridgeProvider.getFieldBridge(entityType, propertyPath) : this.getDefaultFieldBridge(entityType, propertyPath);
    }

    public FieldBridge getDefaultFieldBridge(String entityType, String[] propertyPath) {
        DocumentBuilderIndexedEntity docBuilder = this.getDocumentBuilder(entityType);
        if (this.isIdentifierProperty(docBuilder, propertyPath)) {
            return docBuilder.getIdBridge();
        }
        TypeMetadata typeMetadata = this.findTailTypeMetadata(docBuilder, propertyPath);
        if (typeMetadata == null) {
            return null;
        }
        String lastName = propertyPath[propertyPath.length - 1];
        PropertyMetadata propertyMetadata = typeMetadata.getPropertyMetadataForProperty(lastName);
        if (propertyMetadata == null) {
            return null;
        }
        return ((DocumentFieldMetadata)propertyMetadata.getFieldMetadataSet().iterator().next()).getFieldBridge();
    }

    public boolean hasProperty(String typeName, String[] propertyPath) {
        DocumentBuilderIndexedEntity docBuilder = this.getDocumentBuilder(typeName);
        if (this.isIdentifierProperty(docBuilder, propertyPath)) {
            return true;
        }
        TypeMetadata typeMetadata = this.findTailTypeMetadata(docBuilder, propertyPath);
        if (typeMetadata == null) {
            return false;
        }
        String lastName = propertyPath[propertyPath.length - 1];
        return typeMetadata.getPropertyMetadataForProperty(lastName) != null || this.findEmbeddedTypeMetadata(typeMetadata, lastName) != null;
    }

    public boolean hasEmbeddedProperty(String typeName, String[] propertyPath) {
        String lastName;
        if (propertyPath.length == 0) {
            return false;
        }
        TypeMetadata typeMetadata = this.findTailTypeMetadata(typeName, propertyPath);
        return this.findEmbeddedTypeMetadata(typeMetadata, lastName = propertyPath[propertyPath.length - 1]) != null;
    }

    public boolean hasAnalyzedProperty(String typeName, String[] propertyPath) {
        DocumentBuilderIndexedEntity docBuilder = this.getDocumentBuilder(typeName);
        if (this.isIdentifierProperty(docBuilder, propertyPath)) {
            return false;
        }
        TypeMetadata typeMetadata = this.findTailTypeMetadata(docBuilder, propertyPath);
        if (typeMetadata == null) {
            return false;
        }
        String lastName = propertyPath[propertyPath.length - 1];
        DocumentFieldMetadata fieldMetadata = (DocumentFieldMetadata)typeMetadata.getPropertyMetadataForProperty(lastName).getFieldMetadataSet().iterator().next();
        Field.Index index = fieldMetadata.getIndex();
        return index == Field.Index.ANALYZED || index == Field.Index.ANALYZED_NO_NORMS;
    }

    private DocumentBuilderIndexedEntity getDocumentBuilder(String typeName) {
        Object entityMetadata = this.getEntityMetadata(typeName);
        if (entityMetadata == null) {
            throw new IllegalStateException("Unknown entity name " + typeName);
        }
        EntityIndexBinding entityIndexBinding = this.searchFactory.getIndexBinding((Class)entityMetadata);
        if (entityIndexBinding == null) {
            throw log.getNoIndexedEntityException(typeName);
        }
        return entityIndexBinding.getDocumentBuilder();
    }

    private boolean isIdentifierProperty(DocumentBuilderIndexedEntity documentBuilder, String[] propertyPath) {
        return propertyPath.length == 1 && propertyPath[0].equals(documentBuilder.getIdentifierName());
    }

    private TypeMetadata findTailTypeMetadata(DocumentBuilderIndexedEntity documentBuilder, String[] propertyPath) {
        TypeMetadata typeMetadata = documentBuilder.getMetadata();
        for (int i = 0; i < propertyPath.length - 1 && (typeMetadata = this.findEmbeddedTypeMetadata(typeMetadata, propertyPath[i])) != null; ++i) {
        }
        return typeMetadata;
    }

    private TypeMetadata findTailTypeMetadata(String typeName, String[] propertyPath) {
        return this.findTailTypeMetadata(this.getDocumentBuilder(typeName), propertyPath);
    }

    private EmbeddedTypeMetadata findEmbeddedTypeMetadata(TypeMetadata typeMetadata, String name) {
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            if (!embeddedTypeMetadata.getEmbeddedFieldName().equals(name)) continue;
            return embeddedTypeMetadata;
        }
        return null;
    }
}

