/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.JPAFilterAndConverterDistTest")
public class JPAFilterAndConverterDistTest
extends MultipleCacheManagersTest {
    protected final int numNodes;

    protected JPAFilterAndConverterDistTest(int numNodes) {
        this.numNodes = numNodes;
    }

    public JPAFilterAndConverterDistTest() {
        this(3);
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = JPAFilterAndConverterDistTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cfgBuilder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        this.createClusteredCaches(this.numNodes, cfgBuilder);
    }

    @Test
    public void testFilter() {
        boolean isClustered = this.cache(0).getCacheConfiguration().clustering().cacheMode().isClustered();
        for (int i = 0; i < 10; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(i + 30);
            Cache cache = this.cache(i % this.numNodes);
            Object key = isClustered ? new MagicKey(cache) : Integer.valueOf(i);
            cache.put(key, (Object)value);
        }
        JPAFilterAndConverter filterAndConverter = new JPAFilterAndConverter("from org.infinispan.query.test.Person where blurb is null and age <= 31", null, ReflectionMatcher.class);
        CacheStream stream = this.cache(0).getAdvancedCache().cacheEntrySet().stream();
        CloseableIterator iterator = Closeables.iterator(CacheFilters.filterAndConvert((Stream)stream, (KeyValueFilterConverter)filterAndConverter).iterator());
        Map<Object, ObjectFilter.FilterResult> results = this.mapFromIterator((CloseableIterator<Map.Entry<Object, ObjectFilter.FilterResult>>)iterator);
        AssertJUnit.assertEquals((int)2, (int)results.size());
        for (ObjectFilter.FilterResult p : results.values()) {
            AssertJUnit.assertNull((Object)((Person)p.getInstance()).getBlurb());
            AssertJUnit.assertTrue((((Person)p.getInstance()).getAge() <= 31 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, ObjectFilter.FilterResult> mapFromIterator(CloseableIterator<Map.Entry<Object, ObjectFilter.FilterResult>> iterator) {
        try {
            HashMap<Object, ObjectFilter.FilterResult> result = new HashMap<Object, ObjectFilter.FilterResult>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                result.put(entry.getKey(), (ObjectFilter.FilterResult)entry.getValue());
            }
            HashMap<Object, ObjectFilter.FilterResult> hashMap = result;
            return hashMap;
        }
        finally {
            iterator.close();
        }
    }
}

