/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryParsingResult;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.query.dsl.impl.BaseQueryBuilder;
import org.infinispan.query.dsl.impl.JPAQueryGenerator;
import org.infinispan.query.dsl.impl.Visitor;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.KeyValuePair;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.QueryCacheEmbeddedTest")
@CleanupAfterMethod
public class QueryCacheEmbeddedTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testQueryCache() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("John");
        this.cache.put((Object)("user_" + user.getId()), (Object)user);
        QueryEngine queryEngine = (QueryEngine)TestingUtil.extractComponent((Cache)this.cache, QueryEngine.class);
        QueryCache queryCache = (QueryCache)TestingUtil.extractField(QueryEngine.class, (Object)queryEngine, (String)"queryCache");
        QueryCache queryCacheSpy = (QueryCache)Mockito.spy((Object)queryCache);
        TestingUtil.replaceField((Object)queryCacheSpy, (String)"queryCache", (Object)queryEngine, QueryEngine.class);
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache);
        QueryBuilder queryQueryBuilder = qf.from(UserHS.class).having("name").eq((Object)"John").toBuilder();
        String jpaQuery = (String)((BaseQueryBuilder)queryQueryBuilder).accept((Visitor)new JPAQueryGenerator());
        AtomicReference<Object> lastGetResult = this.captureLastGetResult(queryCacheSpy);
        KeyValuePair queryCacheKey = new KeyValuePair((Object)jpaQuery, FilterParsingResult.class);
        FilterParsingResult cachedParsingResult = (FilterParsingResult)queryCache.get(queryCacheKey);
        AssertJUnit.assertNull((Object)cachedParsingResult);
        queryQueryBuilder.build().list();
        cachedParsingResult = (FilterParsingResult)queryCache.get(queryCacheKey);
        AssertJUnit.assertNotNull((Object)cachedParsingResult);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{queryCacheSpy});
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.calls((int)1))).get(queryCacheKey);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FilterParsingResult.class);
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.calls((int)1))).put((KeyValuePair)Matchers.eq((Object)queryCacheKey), captor.capture());
        inOrder.verifyNoMoreInteractions();
        AssertJUnit.assertNull((Object)lastGetResult.get());
        AssertJUnit.assertTrue((captor.getValue() == cachedParsingResult ? 1 : 0) != 0);
        Mockito.reset((Object[])new QueryCache[]{queryCacheSpy});
        lastGetResult = this.captureLastGetResult(queryCacheSpy);
        queryQueryBuilder.build().list();
        inOrder = Mockito.inOrder((Object[])new Object[]{queryCacheSpy});
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.calls((int)1))).get(queryCacheKey);
        ((QueryCache)inOrder.verify((Object)queryCacheSpy, Mockito.never())).put((KeyValuePair)Matchers.any(KeyValuePair.class), Matchers.any(LuceneQueryParsingResult.class));
        inOrder.verifyNoMoreInteractions();
        AssertJUnit.assertTrue((lastGetResult.get() == cachedParsingResult ? 1 : 0) != 0);
    }

    private AtomicReference<Object> captureLastGetResult(QueryCache queryCacheSpy) {
        final AtomicReference<Object> lastResult = new AtomicReference<Object>();
        ((QueryCache)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object result = invocation.callRealMethod();
                lastResult.set(result);
                return result;
            }
        }).when((Object)queryCacheSpy)).get((KeyValuePair)Matchers.any(KeyValuePair.class));
        return lastResult;
    }
}

