/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.query.indexmanager.AbstractUpdateCommand;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.LogFactory;

public class AffinityUpdateCommand
extends AbstractUpdateCommand {
    private static final Log log = (Log)LogFactory.getLog(AffinityUpdateCommand.class, Log.class);
    public static final byte COMMAND_ID = 104;

    public AffinityUpdateCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public void setSerializedWorkList(byte[] serializedModel) {
        super.setSerializedWorkList(serializedModel);
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        if (this.queryInterceptor.isStopping()) {
            throw log.cacheIsStoppingNoCommandAllowed(this.cacheName.toString());
        }
        List luceneWorks = this.searchFactory.getWorkSerializer().toLuceneWorks(this.serializedModel);
        List<LuceneWork> workToApply = this.transformKeysToStrings(luceneWorks);
        for (LuceneWork luceneWork : luceneWorks) {
            IndexManager im = this.getIndexManagerForWrites(luceneWork);
            try {
                if (log.isDebugEnabled()) {
                    log.debugf("Performing remote affinity work %s command on index %s", workToApply, im.getIndexName());
                }
                im.performOperations(Collections.singletonList(luceneWork), null);
            }
            catch (Exception e) {
                return CompletableFuture.completedFuture(new ExceptionResponse(e));
            }
        }
        return CompletableFuture.completedFuture(SuccessfulResponse.create((Object)Boolean.TRUE));
    }

    private IndexManager getIndexManagerForWrites(LuceneWork luceneWork) {
        Class entityClass = luceneWork.getEntityClass();
        Serializable id = luceneWork.getId();
        String idInString = luceneWork.getIdInString();
        Document document = luceneWork.getDocument();
        return this.searchFactory.getIndexBinding(entityClass).getSelectionStrategy().getIndexManagerForAddition(entityClass, id, idInString, document);
    }

    @Override
    public byte getCommandId() {
        return 104;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

