/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.AffinityPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.affinity.AffinityIndexManager;
import org.infinispan.query.affinity.Entity;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;

public abstract class BaseAffinityTest
extends MultipleCacheManagersTest {
    private static final String DEFAULT_INDEX_MANAGER = AffinityIndexManager.class.getName();
    private static final int DEFAULT_NUM_ENTRIES = 50;
    private static final int DEFAULT_NUM_SEGMENTS = 256;
    private static final int DEFAULT_NUM_OWNERS = 2;
    private static final int DEFAULT_NUM_SHARDS = 256;
    private static final int DEFAULT_REMOTE_TIMEOUT_MINUTES = 1;
    private static final int DEFAULT_INDEXING_THREADS_PER_NODE = 3;
    private static final int DEFAULT_QUERYING_THREADS_PER_NODE = 10;
    private static final int DEFAULT_INDEXING_NODES = 3;
    private static final int DEFAULT_QUERYING_NODES = 1;
    private static final String DEFAULT_READER_REFRESH_MS = "100";
    private static final String DEFAULT_WORKER = "sync";
    private static final String DEFAULT_READER = "shared";
    private static final QueryType DEFAULT_QUERY_TYPE = QueryType.TERM;
    private static final String ENTRIES_SYS_PROP = "entries";
    private static final String INDEX_MANAGER_SYS_PROP = "indexmanager";
    private static final String SEGMENTS_SYS_PROP = "segments";
    private static final String SHARDS_SYS_PROP = "shards";
    private static final String INDEX_THREADS_SYS_PROP = "index_threads_per_node";
    private static final String QUERY_THREADS_SYS_PROP = "query_threads_per_node";
    private static final String WORKER_SYS_PROP = "worker";
    private static final String QUERY_TYPE_SYS_PROP = "query_type";
    private static final String INDEXING_NODES_SYS_PROP = "index_nodes";
    private static final String QUERYING_NODES_SYS_PROP = "query_nodes";
    private static final String READER_SYS_PROP = "reader_strategy";
    private static final String READER_REFRESH = "reader_refresh";
    protected Random random = new Random();

    protected String getIndexManager() {
        return System.getProperty(INDEX_MANAGER_SYS_PROP, DEFAULT_INDEX_MANAGER);
    }

    protected int getNumEntries() {
        return Integer.getInteger(ENTRIES_SYS_PROP, 50);
    }

    protected int getNumSegments() {
        return Integer.getInteger(SEGMENTS_SYS_PROP, 256);
    }

    protected String getNumShards() {
        return System.getProperty(SHARDS_SYS_PROP, String.valueOf(256));
    }

    protected int getRemoteTimeoutInMinutes() {
        return 1;
    }

    protected int getIndexThreadsPerNode() {
        return Integer.getInteger(INDEX_THREADS_SYS_PROP, 3);
    }

    protected int getQueryThreadsPerNode() {
        return Integer.getInteger(QUERY_THREADS_SYS_PROP, 10);
    }

    protected int getQueryingNodes() {
        return Integer.getInteger(QUERYING_NODES_SYS_PROP, 1);
    }

    protected int getIndexingNodes() {
        return Integer.getInteger(INDEXING_NODES_SYS_PROP, 3);
    }

    protected String getWorker() {
        return System.getProperty(WORKER_SYS_PROP, DEFAULT_WORKER);
    }

    protected String getReaderStrategy() {
        return System.getProperty(READER_SYS_PROP, DEFAULT_READER);
    }

    protected String getReaderRefresh() {
        return System.getProperty(READER_REFRESH, DEFAULT_READER_REFRESH_MS);
    }

    protected QueryType getQueryType() {
        String sysProp = System.getProperty(QUERY_TYPE_SYS_PROP);
        return sysProp == null ? DEFAULT_QUERY_TYPE : QueryType.valueOf(sysProp.toUpperCase());
    }

    protected Map<String, String> getIndexingProperties() {
        String indexManager = this.getIndexManager();
        HashMap<String, String> props = new HashMap<String, String>(5);
        props.put("hibernate.search.lucene_version", "LUCENE_CURRENT");
        props.put("entity.indexmanager", indexManager);
        props.put("default.worker.execution", this.getWorker());
        props.put("default.reader.strategy", this.getReaderStrategy());
        props.put("default.indexwriter.merge_factor", "30");
        props.put("default.indexwriter.merge_max_size", "1024");
        props.put("default.indexwriter.ram_buffer_size", "256");
        props.put("default.reader.async_refresh_period_ms", this.getReaderRefresh());
        if (indexManager.equals(AffinityIndexManager.class.getName())) {
            props.put("entity.sharding_strategy.nbr_of_shards", this.getNumShards());
        }
        return props;
    }

    protected ConfigurationBuilder getBaseConfigBuilder(CacheMode cacheMode) {
        ConfigurationBuilder configBuilder = BaseAffinityTest.getDefaultClusteredCacheConfig((CacheMode)cacheMode, (boolean)false);
        HashConfigurationBuilder hashConfigurationBuilder = configBuilder.clustering().remoteTimeout((long)this.getRemoteTimeoutInMinutes(), TimeUnit.MINUTES).hash().numSegments(this.getNumSegments()).numOwners(this.getNumOwners());
        if (this.getIndexManager().equals(AffinityIndexManager.class.getName())) {
            hashConfigurationBuilder.keyPartitioner((KeyPartitioner)new AffinityPartitioner());
        }
        return configBuilder;
    }

    protected ConfigurationBuilder getDefaultCacheConfigBuilder() {
        ConfigurationBuilder baseConfigBuilder = this.getBaseConfigBuilder(CacheMode.DIST_SYNC);
        IndexingConfigurationBuilder indexCfgBuilder = baseConfigBuilder.indexing().index(Index.PRIMARY_OWNER).addIndexedEntity(Entity.class);
        this.getIndexingProperties().entrySet().forEach(entry -> indexCfgBuilder.addProperty((String)entry.getKey(), (String)entry.getValue()));
        return baseConfigBuilder;
    }

    protected ConfigurationChildBuilder getBaseIndexCacheConfig(CacheMode mode) {
        ConfigurationBuilder baseConfig = this.getBaseConfigBuilder(mode);
        return baseConfig.indexing().index(Index.NONE);
    }

    protected Configuration getLockCacheConfig() {
        return this.getBaseIndexCacheConfig(CacheMode.REPL_SYNC).build();
    }

    protected Configuration getMetadataCacheConfig() {
        return this.getBaseIndexCacheConfig(CacheMode.DIST_SYNC).build();
    }

    protected Configuration getDataCacheConfig() {
        return this.getBaseIndexCacheConfig(CacheMode.DIST_SYNC).build();
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder builder, TransportFlags flags) {
        EmbeddedCacheManager cm = super.addClusterEnabledCacheManager(builder, flags);
        this.configureIndexCaches(Collections.singleton(cm));
        return cm;
    }

    private void configureIndexCaches(Collection<EmbeddedCacheManager> managers) {
        managers.forEach(cm -> {
            cm.defineConfiguration("LuceneIndexesLocking", this.getLockCacheConfig());
            cm.defineConfiguration("LuceneIndexesMetadata", this.getMetadataCacheConfig());
            cm.defineConfiguration("LuceneIndexesData", this.getDataCacheConfig());
        });
    }

    protected int getNumOwners() {
        return 2;
    }

    synchronized Cache<String, Entity> pickCache() {
        List caches = this.caches();
        return (Cache)caches.get(this.random.nextInt(caches.size()));
    }

    protected void assertDocsIndexed(long millis) {
        int numEntries = this.getNumEntries();
        this.eventually(() -> {
            CacheQuery query = Search.getSearchManager(this.pickCache()).getQuery((Query)new MatchAllDocsQuery(), new Class[0]).projection(new String[]{"val"});
            Set indexedDocsIds = query.list().stream().map(projections -> (Integer)projections[0]).collect(Collectors.toSet());
            int resultSize = indexedDocsIds.size();
            return resultSize == numEntries;
        }, millis);
    }

    void populate(int initialId, int finalId) {
        IntStream.rangeClosed(initialId, finalId).forEach(i -> {
            Entity cfr_ignored_0 = (Entity)this.pickCache().put((Object)String.valueOf(i), (Object)new Entity(i));
        });
    }

    synchronized void addNode() {
        EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(this.getDefaultCacheConfigBuilder());
        this.configureIndexCaches(Collections.singleton(cacheManager));
        this.waitForClusterToForm();
    }

    class NodeSummary {
        private final Histogram histogram;
        private final long totalTimeMs;

        NodeSummary(Histogram histogram, long totalTimeMs) {
            this.histogram = histogram;
            this.totalTimeMs = totalTimeMs;
        }

        double getOpsPerSecond() {
            return (double)this.histogram.getTotalCount() / ((double)this.totalTimeMs / 1000.0);
        }

        double getValueAtPercentile(int percentile) {
            return (double)this.histogram.getValueAtPercentile((double)percentile) / 1000000.0;
        }

        void outputHistogram() {
            this.histogram.outputPercentileDistribution(System.out, Double.valueOf(1000000.0));
        }
    }

    class TimeBoundQueryNode
    extends QueryingNode {
        private final long durationNanos;
        private final long waitIntervalNanos;

        TimeBoundQueryNode(long totalTime, TimeUnit totalTimeUnit, long waitBetweenQueries, TimeUnit waiTimeUnit, int nThreads, QueryType queryType) {
            super(nThreads, null, queryType);
            this.waitIntervalNanos = TimeUnit.NANOSECONDS.convert(waitBetweenQueries, waiTimeUnit);
            this.durationNanos = TimeUnit.NANOSECONDS.convert(totalTime, totalTimeUnit);
        }

        @Override
        protected int getRandomTerm() {
            return BaseAffinityTest.this.random.nextInt(BaseAffinityTest.this.getNumEntries());
        }

        @Override
        void executeTask() {
            long now = System.nanoTime();
            long timeLimit = now + this.durationNanos;
            Query luceneQuery = this.createLuceneQuery();
            CacheQuery q = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[]{Entity.class});
            while (timeLimit - System.nanoTime() > 0L) {
                long start = System.nanoTime();
                q.list();
                this.latencyStats.recordLatency(System.nanoTime() - start);
                LockSupport.parkNanos(this.waitIntervalNanos);
            }
        }
    }

    class QueryingNode
    extends TaskNode {
        static final int QUERY_INTERVAL_MS = 10;
        final QueryType queryType;

        QueryingNode(int nThreads, AtomicInteger globalCounter, QueryType queryType) {
            super(nThreads, globalCounter);
            this.queryType = queryType;
        }

        protected Query createLuceneQuery() {
            if (this.queryType == QueryType.MATCH_ALL) {
                return new MatchAllDocsQuery();
            }
            if (this.queryType == QueryType.TERM) {
                return Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Entity.class).get().keyword().onField("val").matching((Object)this.getRandomTerm()).createQuery();
            }
            return null;
        }

        protected int getRandomTerm() {
            return Math.round((float)((double)this.globalCounter.get() * 0.75));
        }

        @Override
        void executeTask() {
            int id = this.globalCounter.get();
            Query luceneQuery = this.createLuceneQuery();
            CacheQuery q = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[]{Entity.class});
            int numEntries = BaseAffinityTest.this.getNumEntries();
            while (id <= numEntries) {
                long start = System.nanoTime();
                q.list();
                this.latencyStats.recordLatency(System.nanoTime() - start);
                id = this.globalCounter.get();
                LockSupport.parkNanos(10000000L);
            }
        }

        @Override
        void warmup() {
            for (int i = 0; i < 1000; ++i) {
                CacheQuery query = Search.getSearchManager((Cache)this.cache).getQuery((Query)new MatchAllDocsQuery(), new Class[]{Entity.class});
                query.list();
            }
        }
    }

    static enum QueryType {
        MATCH_ALL,
        TERM;

    }

    class IndexingNode
    extends TaskNode {
        IndexingNode(int nThreads, AtomicInteger globalCounter) {
            super(nThreads, globalCounter);
        }

        @Override
        void executeTask() {
            int id = 0;
            int numEntries = BaseAffinityTest.this.getNumEntries();
            while (id <= numEntries) {
                id = this.globalCounter.incrementAndGet();
                if (id > numEntries) continue;
                long start = System.nanoTime();
                this.cache.put((Object)String.valueOf(id), (Object)new Entity(id));
                System.out.println("Put " + id);
                this.latencyStats.recordLatency(System.nanoTime() - start);
            }
        }

        @Override
        void warmup() {
            for (int i = 0; i < 1000; ++i) {
                this.cache.put((Object)String.valueOf(BaseAffinityTest.this.random.nextInt(1000)), (Object)new Entity(i));
                if (i % 100 != 0) continue;
                System.out.printf("[Warmup] Added %d entries\n", i);
            }
        }
    }

    abstract class TaskNode
    extends Node {
        private final ExecutorService executorService;
        private int nThreads;
        protected AtomicInteger globalCounter;

        TaskNode(int nThreads, AtomicInteger globalCounter) {
            this.executorService = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setName("TaskNode");
                    return thread;
                }
            });
            this.nThreads = nThreads;
            this.globalCounter = globalCounter;
        }

        @Override
        void kill() {
            this.executorService.shutdownNow();
            super.kill();
        }

        abstract void executeTask();

        @Override
        abstract void warmup();

        @Override
        CompletableFuture<Void> run() {
            List<CompletableFuture> futures = IntStream.range(0, this.nThreads).boxed().map(t -> CompletableFuture.supplyAsync(() -> {
                this.executeTask();
                return null;
            }, this.executorService)).collect(Collectors.toList());
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[this.nThreads]));
        }
    }

    abstract class Node {
        protected EmbeddedCacheManager cacheManager;
        protected Cache<String, Entity> cache;
        final int WARMUP_ITERATIONS = 1000;
        final LatencyStats latencyStats = new LatencyStats();

        Node() {
        }

        Node addToCluster() {
            this.cacheManager = BaseAffinityTest.this.addClusterEnabledCacheManager(BaseAffinityTest.this.getDefaultCacheConfigBuilder());
            this.cache = this.cacheManager.getCache();
            return this;
        }

        void kill() {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
            BaseAffinityTest.this.cacheManagers.remove(this.cacheManager);
        }

        abstract CompletableFuture<Void> run();

        abstract void warmup();

        NodeSummary getNodeSummary(long timeMs) {
            Histogram intervalHistogram = this.latencyStats.getIntervalHistogram();
            return new NodeSummary(intervalHistogram, timeMs);
        }
    }
}

