/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.SingleClassDSLQueryTest")
public class SingleClassDSLQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().index(Index.ALL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    public void testQuery() throws Exception {
        Cache cache = this.cacheManager.getCache();
        cache.put((Object)"person1", (Object)new Person("William", "Shakespeare"));
        QueryFactory queryFactory = Search.getQueryFactory((Cache)cache);
        Query query = queryFactory.from(Person.class).having("name").eq((Object)"William").build();
        List matches = query.list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    @Indexed
    static class Person {
        @Field(store=Store.YES, analyze=Analyze.NO)
        String name;
        @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
        String surname;

        public Person(String name, String surname) {
            this.name = name;
            this.surname = surname;
        }
    }
}

