/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.syntax.parser.FilterParsingResult;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

final class DelegatingQuery<TypeMetadata>
extends BaseQuery {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)DelegatingQuery.class.getName());
    private final QueryEngine<TypeMetadata> queryEngine;
    private final FilterParsingResult<TypeMetadata> parsingResult;
    private BaseQuery query;

    DelegatingQuery(QueryEngine<TypeMetadata> queryEngine, QueryFactory queryFactory, String queryString) {
        super(queryFactory, queryString);
        this.queryEngine = queryEngine;
        this.parsingResult = queryEngine.parse(queryString);
        if (!this.parsingResult.getParameterNames().isEmpty()) {
            this.namedParameters = new HashMap(this.parsingResult.getParameterNames().size());
            for (String paramName : this.parsingResult.getParameterNames()) {
                this.namedParameters.put(paramName, null);
            }
        }
    }

    DelegatingQuery(QueryEngine<TypeMetadata> queryEngine, QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults);
        this.queryEngine = queryEngine;
        this.parsingResult = queryEngine.parse(queryString);
        if (namedParameters != null) {
            ArrayList<String> unknownParams = null;
            for (String paramName : namedParameters.keySet()) {
                if (paramName == null || paramName.isEmpty()) {
                    throw log.parameterNameCannotBeNulOrEmpty();
                }
                if (this.parsingResult.getParameterNames().contains(paramName)) continue;
                if (unknownParams == null) {
                    unknownParams = new ArrayList<String>();
                }
                unknownParams.add(paramName);
            }
            if (unknownParams != null) {
                throw log.parametersNotFound(((Object)unknownParams).toString());
            }
        }
    }

    public String[] getProjection() {
        return this.parsingResult.getProjections();
    }

    public void resetQuery() {
        if (this.query != null) {
            this.query.resetQuery();
        }
    }

    private Query createQuery() {
        if (this.query == null) {
            this.query = this.queryEngine.buildQuery(this.queryFactory, this.parsingResult, this.namedParameters, this.startOffset, this.maxResults);
        }
        return this.query;
    }

    public <T> List<T> list() {
        return this.createQuery().list();
    }

    public int getResultSize() {
        return this.createQuery().getResultSize();
    }

    public String toString() {
        return "DelegatingQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

