/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.testdomain.hsearch;

import java.io.Serializable;
import java.util.Date;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.EncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.infinispan.marshall.core.ExternalPojo;
import org.infinispan.query.dsl.embedded.testdomain.Transaction;

@Indexed
public class TransactionHS
implements Transaction,
Serializable,
ExternalPojo {
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    private int id;
    @Field(store=Store.NO, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
    @SortableField
    private String description;
    @Field
    @SortableField
    private String longDescription;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private int accountId;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @DateBridge(encoding=EncodingType.STRING, resolution=Resolution.MILLISECOND)
    private Date date;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @NumericField
    private double amount;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private boolean isDebit;
    private boolean isValid;

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getAccountId() {
        return this.accountId;
    }

    @Override
    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Override
    public boolean isDebit() {
        return this.isDebit;
    }

    @Override
    public void setDebit(boolean isDebit) {
        this.isDebit = isDebit;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionHS other = (TransactionHS)o;
        if (this.accountId != other.accountId) {
            return false;
        }
        if (Double.compare(other.amount, this.amount) != 0) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isDebit != other.isDebit) {
            return false;
        }
        if (this.isValid != other.isValid) {
            return false;
        }
        if (this.date != null ? !this.date.equals(other.date) : other.date != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(other.description) : other.description != null) {
            return false;
        }
        return !(this.longDescription != null ? !this.longDescription.equals(other.longDescription) : other.longDescription != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.longDescription != null ? this.longDescription.hashCode() : 0);
        result = 31 * result + this.accountId;
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.amount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isDebit ? 1 : 0);
        result = 31 * result + (this.isValid ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TransactionHS{id=" + this.id + ", description='" + this.description + '\'' + ", longDescription='" + this.longDescription + '\'' + ", accountId=" + this.accountId + ", date=" + this.date + ", amount=" + this.amount + ", isDebit=" + this.isDebit + ", isValid=" + this.isValid + '}';
    }
}

