/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.util.Sets;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.syntax.parser.FilterParsingResult;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryParsingResult;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.QueryCacheEmbeddedTest")
@CleanupAfterMethod
public class QueryCacheEmbeddedTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(UserHS.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testQueryCache() throws Exception {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("John");
        this.cache.put((Object)("user_" + user.getId()), (Object)user);
        QueryCache queryCache = ComponentRegistryUtils.getQueryCache((Cache)this.cache);
        queryCache.clear();
        Cache internalCache = (Cache)TestingUtil.extractField(QueryCache.class, (Object)queryCache, (String)"lazyCache");
        String queryString = "from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u where u.name = 'John'";
        int[] invoked = new int[]{0};
        FilterParsingResult created = (FilterParsingResult)queryCache.get(queryString, null, FilterParsingResult.class, (qs, acc) -> {
            invoked[0] = invoked[0] + 1;
            return null;
        });
        AssertJUnit.assertEquals((int)1, (int)invoked[0]);
        AssertJUnit.assertNull((Object)created);
        AssertJUnit.assertEquals((int)0, (int)internalCache.size());
        Query query = Search.getQueryFactory((Cache)this.cache).create(queryString);
        query.list();
        AssertJUnit.assertEquals((int)2, (int)internalCache.size());
        Set cacheValueClasses = (Set)internalCache.entrySet().stream().map((SerializableFunction & Serializable)e -> e.getValue().getClass()).collect(Collectors.toSet());
        LinkedHashSet expectedCachedValueClasses = Sets.newLinkedHashSet((Object[])new Class[]{FilterParsingResult.class, LuceneQueryParsingResult.class});
        AssertJUnit.assertEquals((Object)expectedCachedValueClasses, (Object)cacheValueClasses);
        FilterParsingResult cached = (FilterParsingResult)queryCache.get(queryString, null, FilterParsingResult.class, (qs, acc) -> {
            throw new AssertionError((Object)"QueryCreator should not be invoked now");
        });
        AssertJUnit.assertNotNull((Object)cached);
    }
}

