/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.persistence;

import java.util.List;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.indexedembedded.City;
import org.infinispan.query.indexedembedded.Country;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.persistence.EntryActivatingTest")
public class EntryActivatingTest
extends AbstractInfinispanTest {
    Cache<String, Country> cache;
    AdvancedLoadWriteStore store;
    CacheContainer cm;
    SearchManager search;
    QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");

    @BeforeClass
    public void setUp() {
        this.recreateCacheManager();
    }

    @AfterClass
    public void tearDown() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cm});
    }

    public void testPersistence() throws PersistenceException, ParseException {
        this.verifyFullTextHasMatches(0);
        Country italy = new Country();
        italy.countryName = "Italy";
        City rome = new City();
        rome.name = "Rome";
        italy.cities.add(rome);
        this.cache.put((Object)"IT", (Object)italy);
        assert (!this.store.contains((Object)"IT"));
        this.verifyFullTextHasMatches(1);
        this.cache.evict((Object)"IT");
        assert (this.store.contains((Object)"IT"));
        InternalCacheEntry internalCacheEntry = this.cache.getAdvancedCache().getDataContainer().get((Object)"IT");
        assert (internalCacheEntry == null);
        this.verifyFullTextHasMatches(1);
        Country country = (Country)this.cache.get((Object)"IT");
        assert (country != null);
        assert ("Italy".equals(country.countryName));
        this.verifyFullTextHasMatches(1);
        this.cache.stop();
        assert (((SearchIntegrator)this.search.unwrap(SearchIntegrator.class)).isStopped());
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cm});
        this.recreateCacheManager();
        this.verifyFullTextHasMatches(0);
    }

    private void recreateCacheManager() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).purgeOnStartup(true)).indexing().index(Index.ALL).addIndexedEntity(Country.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
        this.cache = this.cm.getCache();
        this.store = (AdvancedLoadWriteStore)TestingUtil.getFirstLoader(this.cache);
        this.search = Search.getSearchManager(this.cache);
    }

    private void verifyFullTextHasMatches(int i) throws ParseException {
        Query query = this.queryParser.parse("Italy");
        List list = this.search.getQuery(query, new Class[]{Country.class, City.class}).list();
        AssertJUnit.assertEquals((int)i, (int)list.size());
    }
}

