/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.File;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.blackbox.ClusteredCacheTest;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredCacheFSDirectoryTest")
public class ClusteredCacheFSDirectoryTest
extends ClusteredCacheTest {
    private final String TMP_DIR = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());

    @Override
    protected void createCacheManagers() throws Exception {
        this.addClusterEnabledCacheManager(this.buildCacheConfig("index1"));
        this.addClusterEnabledCacheManager(this.buildCacheConfig("index2"));
        this.waitForClusterToForm();
        this.cache1 = this.cache(0);
        this.cache2 = this.cache(1);
    }

    private ConfigurationBuilder buildCacheConfig(String indexName) {
        ConfigurationBuilder cb = ClusteredCacheFSDirectoryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        cb.indexing().index(Index.ALL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "filesystem").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("default.indexBase", this.TMP_DIR + File.separator + indexName).addProperty("lucene_version", "LUCENE_CURRENT");
        return cb;
    }

    @BeforeMethod
    protected void setUpTempDir() {
        new File(this.TMP_DIR).mkdirs();
    }

    @AfterMethod
    protected void clearContent() throws Throwable {
        try {
            super.clearContent();
        }
        finally {
            Util.recursiveFileRemove((String)this.TMP_DIR);
        }
    }
}

