/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.queryparser.classic.ParseException;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="query.config.DeclarativeConfigTest", groups={"functional"})
public class DeclarativeConfigTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        String config = TestingUtil.InfinispanStartTag.LATEST + "\n<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <indexing index=\"LOCAL\">\n            <property name=\"default.directory_provider\">ram</property>\n            <property name=\"lucene_version\">LUCENE_CURRENT</property>\n      </indexing>\n   </local-cache>\n</cache-container>" + "</infinispan>";
        this.log.tracef("Using test configuration:\n%s", (Object)config);
        try (ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());){
            this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        this.cache = this.cacheManager.getCache();
        return this.cacheManager;
    }

    public void simpleIndexTest() throws ParseException {
        this.cache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(this.cache, "name", "Name");
        AssertJUnit.assertEquals((int)1, (int)cq.getResultSize());
        List l = cq.list();
        AssertJUnit.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        AssertJUnit.assertEquals((String)"A Person's Name", (String)p.getName());
        AssertJUnit.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        AssertJUnit.assertEquals((int)75, (int)p.getAge());
    }

    @Test(dependsOnMethods={"simpleIndexTest"})
    public void testPropertiesWhereRead() {
        SearchIntegrator searchFactory = TestQueryHelperFactory.extractSearchFactory(this.cache);
        EntityIndexBinding indexBindingForEntity = searchFactory.getIndexBinding(Person.class);
        IndexManager[] managers = indexBindingForEntity.getIndexManagers();
        AssertJUnit.assertEquals((int)1, (int)managers.length);
        AssertJUnit.assertNotNull((Object)managers[0]);
        AssertJUnit.assertTrue((boolean)(managers[0] instanceof DirectoryBasedIndexManager));
        DirectoryBasedIndexManager dbim = (DirectoryBasedIndexManager)managers[0];
        AssertJUnit.assertTrue((boolean)(dbim.getDirectoryProvider() instanceof RAMDirectoryProvider));
    }
}

