/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.phrases;

import java.util.List;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.queries.NumericType;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.queries.phrases.QueryPhrasesTest")
public class QueryPhrasesTest
extends SingleCacheManagerTest {
    private Person person1;
    private Person person2;
    private Person person3;
    private Person person4;
    protected String key1 = "test1";
    protected String key2 = "test2";
    protected String key3 = "test3";
    private NumericType type1;
    private NumericType type2;
    private NumericType type3;

    public QueryPhrasesTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(NumericType.class).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testBooleanQueriesMustNot() throws ParseException {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().bool().must(TestQueryHelperFactory.createQueryParser("name").parse("Goat")).not().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(this.person1));
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().bool().must(TestQueryHelperFactory.createQueryParser("name").parse("Goat")).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
    }

    public void testBooleanQueriesOnMultipleTables() throws ParseException {
        this.loadTestingData();
        AnotherGrassEater anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
        this.cache.put((Object)"key4", (Object)anotherGrassEater);
        Query subQuery = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").below((Object)20).createQuery();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(AnotherGrassEater.class).get().bool().should(TestQueryHelperFactory.createQueryParser("name").parse("grass")).should(subQuery).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(anotherGrassEater));
    }

    public void testBooleanQueriesShould() throws ParseException {
        this.loadTestingData();
        Query subQuery = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").below((Object)20).createQuery();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().bool().should(TestQueryHelperFactory.createQueryParser("name").parse("Goat")).should(subQuery).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        subQuery = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").below((Object)20).excludeLimit().createQuery();
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().bool().should(TestQueryHelperFactory.createQueryParser("name").parse("Goat")).should(subQuery).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
    }

    public void testBooleanQueriesShouldNot() throws ParseException {
        this.loadTestingData();
        Query subQuery1 = ((TermMatchingContext)Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").boostedTo(0.5f)).matching((Object)"Goat").createQuery();
        Query subQuery2 = ((RangeMatchingContext)Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").boostedTo(2.0f)).below((Object)20).createQuery();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().bool().should(subQuery1).should(subQuery2).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.get(0).equals(this.person1));
        assert (found.get(1).equals(this.person2));
        assert (found.get(2).equals(this.person3));
        subQuery1 = ((TermMatchingContext)Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").boostedTo(3.5f)).matching((Object)"Goat").createQuery();
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().bool().should(subQuery1).should(subQuery2).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.get(0).equals(this.person2));
        assert (found.get(1).equals(this.person3));
        assert (found.get(2).equals(this.person1));
    }

    public void testFuzzyOnFieldsAndField() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().onField("name").matching((Object)"Goat").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        this.person4 = new Person();
        this.person4.setName("Test");
        this.person4.setBlurb("Test goat");
        this.cache.put((Object)"testKey", (Object)this.person4);
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().onField("name").andField("blurb").matching((Object)"goat").createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().onFields(new String[]{"name", "blurb"}).matching((Object)"goat").createQuery();
        List foundOnFields = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    public void testFuzzyWithThresholdWithPrefixLength() {
        this.person1 = new Person("yyJohn", "Eat anything", 10);
        this.person2 = new Person("yyJonn", "Eat anything", 10);
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().withEditDistanceUpTo(1).withPrefixLength(2).onField("name").matching((Object)"yyJohny").createQuery();
        List found = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]).list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person1));
        Query queryReturnAll = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().withEditDistanceUpTo(2).withPrefixLength(2).onField("name").matching((Object)"yyJohn").createQuery();
        List foundWithLowerThreshold = Search.getSearchManager((Cache)this.cache).getQuery(queryReturnAll, new Class[0]).list();
        AssertJUnit.assertEquals((int)2, (int)foundWithLowerThreshold.size());
        AssertJUnit.assertTrue((boolean)foundWithLowerThreshold.contains(this.person1));
        AssertJUnit.assertTrue((boolean)foundWithLowerThreshold.contains(this.person2));
    }

    public void testQueryingRangeWithAnd() {
        NumericType type1 = new NumericType(10, 20);
        NumericType type2 = new NumericType(20, 10);
        NumericType type3 = new NumericType(10, 10);
        this.cache.put((Object)this.key1, (Object)type1);
        this.cache.put((Object)this.key2, (Object)type2);
        this.cache.put((Object)this.key3, (Object)type3);
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().range().onField("num1").andField("num2").below((Object)20).excludeLimit().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(type1));
        assert (found.contains(type2));
        assert (found.contains(type3));
        NumericType type4 = new NumericType(11, 10);
        this.cache.put((Object)"newKey", (Object)type4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)4, (int)found.size());
        assert (found.contains(type3));
        assert (found.contains(type2));
        assert (found.contains(type1));
        assert (found.contains(type4));
    }

    @Test(expectedExceptions={SearchException.class})
    public void testWildcardWithWrongName() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().wildcard().onField("wrongname").matching((Object)"Goat").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
    }

    public void testWildcard() {
        this.loadNumericTypes();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"*wildcard*").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.type1));
        assert (found.contains(this.type2));
        assert (found.contains(this.type3));
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"nothing*").createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        NumericType type4 = new NumericType(35, 40);
        type4.setName("nothing special.");
        this.cache.put((Object)"otherKey", (Object)type4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(type4));
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"*nothing*").createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.type2));
        assert (found.contains(type4));
    }

    public void testKeyword() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").andField("blurb").matching((Object)"Eats").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        this.person4 = new Person();
        this.person4.setName("Some name with Eats");
        this.person4.setBlurb("Description without keyword.");
        this.cache.put((Object)"someKey", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    public void testPhraseSentence() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().phrase().onField("blurb").sentence("Eats grass").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(this.person2));
        this.person4 = new Person();
        this.person4.setName("Another goat");
        this.person4.setBlurb("Eats grass and drinks water.");
        this.cache.put((Object)"anotherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
    }

    public void testPhraseSentenceForNonAnalyzedEntries() {
        this.loadNumericTypes();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().phrase().onField("name").sentence("Some string").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        NumericType type4 = new NumericType(45, 50);
        type4.setName("Some string");
        this.cache.put((Object)"otherKey", (Object)type4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(type4));
    }

    public void testPhraseWithSlop() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().phrase().withSlop(3).onField("blurb").sentence("Eats grass").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(this.person2));
        this.person4 = new Person();
        this.person4.setName("other goat");
        this.person4.setBlurb("Eats green grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        this.person4.setBlurb("Eats green tasty grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        this.person4.setBlurb("Eats green, tasty, juicy grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        this.person4.setBlurb("Eats green, tasty, juicy, fresh grass.");
        this.cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(this.person2));
    }

    public void testPhraseWithSlopWithoutAnalyzer() {
        this.loadNumericTypes();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().phrase().withSlop(1).onField("name").sentence("Some string").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        NumericType type = new NumericType(10, 60);
        type.setName("Some string");
        this.cache.put((Object)"otherKey", (Object)type);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(type));
        NumericType type1 = new NumericType(20, 60);
        type1.setName("Some other string");
        this.cache.put((Object)"otherKey1", (Object)type1);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(type));
    }

    public void testAllExcept() {
        this.loadTestingData();
        Query subQuery = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").matching((Object)"Goat").createQuery();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().all().except(new Query[0]).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().all().except(new Query[]{query}).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(Person.class).get().all().except(new Query[]{subQuery}).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        assert (found.contains(this.person1));
    }

    public void testAllExceptWithoutAnalyzer() {
        this.loadNumericTypes();
        Query subQuery = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"*string*").createQuery();
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().all().except(new Query[0]).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.type1));
        assert (found.contains(this.type2));
        assert (found.contains(this.type3));
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(NumericType.class).get().all().except(new Query[]{subQuery}).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
    }

    protected void loadTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(20);
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(30);
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(25);
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
    }

    private void loadNumericTypes() {
        this.type1 = new NumericType(10, 20);
        this.type1.setName("Some string for testing wildcards.");
        this.type2 = new NumericType(15, 25);
        this.type2.setName("This string has nothing to do with wildcards.");
        this.type3 = new NumericType(20, 30);
        this.type3.setName("Some other string for testing wildcards.");
        this.cache.put((Object)this.key1, (Object)this.type1);
        this.cache.put((Object)this.key2, (Object)this.type2);
        this.cache.put((Object)this.key3, (Object)this.type3);
    }
}

