/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredQueryTest")
public class ClusteredQueryTest
extends MultipleCacheManagersTest {
    private final QueryParser queryParser = TestQueryHelperFactory.createQueryParser("blurb");
    static final int NUM_ENTRIES = 30;
    Cache<String, Person> cacheAMachine1;
    Cache<String, Person> cacheAMachine2;
    CacheQuery<Person> cacheQuery;

    public ClusteredQueryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void enhanceConfig(ConfigurationBuilder cacheCfg) {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredQueryTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        cacheCfg.indexing().index(Index.LOCAL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "ram").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        this.enhanceConfig(cacheCfg);
        List caches = this.createClusteredCaches(2, cacheCfg);
        this.cacheAMachine1 = (Cache)caches.get(0);
        this.cacheAMachine2 = (Cache)caches.get(1);
    }

    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    protected void prepareTestData() {
        IntStream.range(0, 30).boxed().map(i -> new Person("name" + i, "blurb" + i, (int)i)).forEach(p -> {
            Cache<String, Person> cache = p.getAge() % 2 == 0 ? this.cacheAMachine1 : this.cacheAMachine2;
            cache.put((Object)p.getName(), p);
        });
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyOrdered() throws ParseException {
        this.populateCache();
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        for (int i = 0; i < 2; ++i) {
            try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
                assert (this.cacheQuery.getResultSize() == 10) : this.cacheQuery.getResultSize();
                int previousAge = 0;
                while (iterator.hasNext()) {
                    Person person = (Person)iterator.next();
                    assert (person.getAge() > previousAge);
                    previousAge = person.getAge();
                }
                continue;
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLazyNonOrdered() throws ParseException {
        this.populateCache();
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            assert (this.cacheQuery.getResultSize() == 10) : this.cacheQuery.getResultSize();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLocalQuery() throws ParseException {
        this.populateCache();
        SearchManager searchManager1 = Search.getSearchManager(this.cacheAMachine1);
        CacheQuery localQuery1 = searchManager1.getQuery((Query)this.createLuceneQuery(), new Class[0]);
        List results1 = localQuery1.list();
        SearchManager searchManager2 = Search.getSearchManager(this.cacheAMachine2);
        CacheQuery localQuery2 = searchManager2.getQuery((Query)this.createLuceneQuery(), new Class[0]);
        List results2 = localQuery2.list();
        AssertJUnit.assertEquals((int)10, (int)(results1.size() + results2.size()));
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEagerOrdered() throws ParseException {
        this.populateCache();
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
            int previousAge = 0;
            while (iterator.hasNext()) {
                Person person = (Person)iterator.next();
                assert (person.getAge() > previousAge);
                previousAge = person.getAge();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={NoSuchElementException.class}, expectedExceptionsMessageRegExp="Out of boundaries")
    public void testIteratorNextOutOfBounds() throws Exception {
        this.populateCache();
        this.cacheQuery.maxResults(1);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (iterator.hasNext());
            iterator.next();
            assert (!iterator.hasNext());
            iterator.next();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() throws Exception {
        this.populateCache();
        this.cacheQuery.maxResults(1);
        try (ResultIterator iterator = this.cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            assert (iterator.hasNext());
            iterator.remove();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testList() throws ParseException {
        this.populateCache();
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        List results = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
        int previousAge = 0;
        for (Person person : results) {
            assert (person.getAge() > previousAge);
            previousAge = person.getAge();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testGetResultSizeList() throws ParseException {
        this.populateCache();
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
    }

    public void testPagination() throws ParseException {
        this.populateCache();
        this.cacheQuery.firstResult(2);
        this.cacheQuery.maxResults(1);
        SortField sortField = new SortField("age", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        this.cacheQuery.sort(sort);
        List results = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)results.size());
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.getResultSize());
        Person result = (Person)results.get(0);
        AssertJUnit.assertEquals((int)12, (int)result.getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test
    public void testPagination2() throws Exception {
        int[] pageSizes;
        for (int pageSize : pageSizes = new int[]{1, 5, 7, 40}) {
            this.testPaginationWithoutSort(pageSize);
            this.testPaginationWithSort(pageSize, "age", SortField.Type.INT);
        }
    }

    private void testPaginationWithoutSort(int pageSize) throws ParseException {
        this.testPaginationInternal(pageSize, null);
    }

    private void testPaginationWithSort(int pageSize, String field, SortField.Type type) throws ParseException {
        this.testPaginationInternal(pageSize, new Sort(new SortField(field, type)));
    }

    private void testPaginationInternal(int pageSize, Sort sort) throws ParseException {
        this.populateCache();
        CacheQuery<Person> paginationQuery = this.buildPaginationQuery(0, pageSize, sort);
        int idx = 0;
        HashSet keys = new HashSet();
        while (idx < 30) {
            List results = paginationQuery.list();
            results.stream().map(Person::getName).forEach(keys::add);
            paginationQuery = this.buildPaginationQuery(idx += pageSize, pageSize, sort);
        }
        AssertJUnit.assertEquals((int)30, (int)keys.size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    private CacheQuery<Person> buildPaginationQuery(int offset, int pageSize, Sort sort) throws ParseException {
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getClusteredQuery((Query)new MatchAllDocsQuery(), new Class[0]);
        clusteredQuery.firstResult(offset);
        clusteredQuery.maxResults(pageSize);
        if (sort != null) {
            clusteredQuery.sort(sort);
        }
        return clusteredQuery;
    }

    public void testQueryAll() throws ParseException {
        this.populateCache();
        CacheQuery clusteredQuery = Search.getSearchManager(this.cacheAMachine1).getClusteredQuery((Query)new MatchAllDocsQuery(), new Class[]{Person.class});
        AssertJUnit.assertEquals((int)30, (int)clusteredQuery.list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    protected void populateCache() throws ParseException {
        this.prepareTestData();
        this.cacheQuery = Search.getSearchManager(this.cacheAMachine1).getClusteredQuery((Query)this.createLuceneQuery(), new Class[0]);
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    protected BooleanQuery createLuceneQuery() throws ParseException {
        return new BooleanQuery.Builder().add(this.queryParser.parse("blurb1?"), BooleanClause.Occur.SHOULD).build();
    }
}

