/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.blackbox.LocalCacheTest;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.blackbox.IndexedEntityAutodetectTest")
public class IndexedEntityAutodetectTest
extends LocalCacheTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    private void assertIndexingKnows(Cache<Object, Object> cache, Class<?> ... types) {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        SearchIntegrator searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        AssertJUnit.assertNotNull((Object)searchIntegrator);
        IndexedTypeMap indexBindingForEntity = ((ExtendedSearchIntegrator)searchIntegrator.unwrap(ExtendedSearchIntegrator.class)).getIndexBindings();
        AssertJUnit.assertNotNull((Object)indexBindingForEntity);
        IndexedTypeSet keySet = indexBindingForEntity.keySet();
        AssertJUnit.assertEquals((int)types.length, (int)keySet.size());
        AssertJUnit.assertTrue((boolean)keySet.containsAll(IndexedTypeSets.fromClasses((Class[])types)));
    }

    @Override
    protected void loadTestingData() {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        super.loadTestingData();
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class, AnotherGrassEater.class);
    }

    public void testEntityDiscovery() {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        Person p = new Person();
        p.setName("Lucene developer");
        p.setAge(30);
        p.setBlurb("works best on weekends");
        this.cache.put((Object)p.getName(), (Object)p);
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class);
    }
}

