/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.VeryLongIndexNamedClass;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredCacheWithLongIndexNameTest")
@CleanupAfterMethod
public class ClusteredCacheWithLongIndexNameTest
extends MultipleCacheManagersTest {
    private Cache cache1;
    private Cache cache2;
    private Cache cache3;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = this.getDefaultConfiguration();
        List caches = this.createClusteredCaches(3, cacheCfg);
        this.cache1 = (Cache)caches.get(0);
        this.cache2 = (Cache)caches.get(1);
        this.cache3 = (Cache)caches.get(2);
    }

    private ConfigurationBuilder getDefaultConfiguration() {
        ConfigurationBuilder cacheCfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)this.transactionsEnabled(), (boolean)false);
        cacheCfg.clustering().cacheMode(this.getCacheMode()).sync().indexing().index(Index.ALL).addIndexedEntity(VeryLongIndexNamedClass.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return cacheCfg;
    }

    public boolean transactionsEnabled() {
        return false;
    }

    public CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    public void testAdditionOfNewNode() {
        this.prepareData();
        SearchManager sm = Search.getSearchManager((Cache)this.cache3);
        QueryBuilder qb = sm.buildQueryBuilderForClass(VeryLongIndexNamedClass.class).get();
        Query q = qb.keyword().wildcard().onField("name").matching((Object)"value*").createQuery();
        CacheQuery cq = sm.getQuery(q, new Class[]{VeryLongIndexNamedClass.class});
        AssertJUnit.assertEquals((int)100, (int)cq.getResultSize());
        this.addClusterEnabledCacheManager(this.getDefaultConfiguration());
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0), this.cache(1), this.cache(2), this.cache(3)});
        sm = Search.getSearchManager((Cache)this.cache(3));
        qb = sm.buildQueryBuilderForClass(VeryLongIndexNamedClass.class).get();
        q = qb.keyword().wildcard().onField("name").matching((Object)"value*").createQuery();
        cq = sm.getQuery(q, new Class[]{VeryLongIndexNamedClass.class});
        AssertJUnit.assertEquals((int)100, (int)cq.getResultSize());
    }

    private void prepareData() {
        VeryLongIndexNamedClass obj = null;
        for (int i = 0; i < 100; ++i) {
            obj = new VeryLongIndexNamedClass("value" + i);
            this.cache1.put((Object)("key" + i), (Object)obj);
        }
    }
}

