/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.indexedembedded.Book;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="query.blackbox.QueryCacheRestartTest", groups={"functional"})
public class QueryCacheRestartTest
extends AbstractInfinispanTest {
    public void testQueryCacheRestart() {
        this.queryCacheRestart(false);
    }

    public void testLocalQueryCacheRestart() {
        this.queryCacheRestart(true);
    }

    private void queryCacheRestart(boolean localOnly) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().index(localOnly ? Index.LOCAL : Index.ALL).addIndexedEntity(Book.class).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        final NoOpInterceptor noOpInterceptor = new NoOpInterceptor();
        builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)noOpInterceptor).position(InterceptorConfiguration.Position.FIRST);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder)){

            public void call() {
                Cache cache = this.cm.getCache();
                this.addABook((Cache<Object, Object>)cache);
                QueryCacheRestartTest.assertFindBook((Cache<Object, Object>)cache);
                cache.stop();
                QueryCacheRestartTest.this.assertCacheHasCustomInterceptor((Cache<Object, Object>)cache, noOpInterceptor);
                cache.start();
                this.addABook((Cache<Object, Object>)cache);
                QueryCacheRestartTest.assertFindBook((Cache<Object, Object>)cache);
                QueryCacheRestartTest.this.assertCacheHasCustomInterceptor((Cache<Object, Object>)cache, noOpInterceptor);
            }

            protected void addABook(Cache<Object, Object> cache) {
                cache.put((Object)"1", (Object)new Book("Infinispan Data Grid Platform", "Francesco Marchioni and Manik Surtani", "Packt Publishing"));
            }
        });
    }

    private void assertCacheHasCustomInterceptor(Cache<Object, Object> cache, CommandInterceptor interceptor) {
        for (InterceptorConfiguration interceptorConfig : cache.getCacheConfiguration().customInterceptors().interceptors()) {
            if (!interceptor.equals(interceptorConfig.interceptor())) continue;
            return;
        }
        AssertJUnit.fail((String)("Expected to find interceptor " + interceptor + " among custom interceptors of cache, but it was not there."));
    }

    private static void assertFindBook(Cache<Object, Object> cache) {
        SearchManager searchManager = Search.getSearchManager(cache);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Book.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("title").matching((Object)"infinispan").createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[0]);
        List list = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    private static class NoOpInterceptor
    extends CommandInterceptor {
        private NoOpInterceptor() {
        }
    }
}

