/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.DeclarativeAutoConfigTest")
public class DeclarativeAutoConfigTest
extends AbstractInfinispanTest {
    @Test
    public void testAutoConfig() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configuration-parsing-test.xml")){

            public void call() {
                Configuration cacheConfiguration = this.cm.getCacheConfiguration("repl-with-default");
                TypedProperties properties = cacheConfiguration.indexing().properties();
                Assert.assertFalse((boolean)properties.isEmpty());
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.exclusive_index_use"), (String)"true");
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.reader.strategy"), (String)"shared");
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.indexmanager"), (String)"near-real-time");
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.directory_provider"), (String)"filesystem");
                cacheConfiguration = this.cm.getCacheConfiguration("dist-with-default");
                properties = cacheConfiguration.indexing().properties();
                Assert.assertFalse((boolean)properties.isEmpty());
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.directory_provider"), (String)"infinispan");
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.indexmanager"), (String)"org.infinispan.query.indexmanager.InfinispanIndexManager");
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.exclusive_index_use"), (String)"true");
                Assert.assertEquals((String)properties.getProperty("hibernate.search.default.reader.strategy"), (String)"shared");
            }
        });
    }
}

