/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.NonIndexedQueryDslConditionsTest")
public class NonIndexedQueryDslConditionsTest
extends QueryDslConditionsTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        this.createClusteredCaches(1, cfg);
    }

    public void testInsertAndIterateInTx() throws Exception {
        final User newUser = this.getModelFactory().makeUser();
        newUser.setId(15);
        newUser.setName("Test");
        newUser.setSurname("User");
        newUser.setGender(User.Gender.MALE);
        newUser.setAge(20);
        List results = (List)TestingUtil.withTx((TransactionManager)this.tm(0), (Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                Query q = NonIndexedQueryDslConditionsTest.this.getQueryFactory().from(NonIndexedQueryDslConditionsTest.this.getModelFactory().getUserImplClass()).not().having("age").eq((Object)20).build();
                NonIndexedQueryDslConditionsTest.this.cache(0).put((Object)("new_user_" + newUser.getId()), (Object)newUser);
                return q.list();
            }
        });
        this.cache(0).remove((Object)("new_user_" + newUser.getId()));
        AssertJUnit.assertEquals((int)3, (int)results.size());
    }

    @Override
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Indexing was not enabled on this cache.*")
    public void testIndexPresence() {
        Search.getSearchManager((Cache)((Cache)this.getCacheForQuery()));
    }

    public void testAnd5() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").lt((Object)1000).and().having("age").lt((Object)1000).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    @Override
    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028521: Full-text queries cannot be applied to property 'longDescription' in type org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS unless the property is indexed and analyzed.")
    public void testFullTextTerm() throws Exception {
        super.testFullTextTerm();
    }

    @Override
    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028521: Full-text queries cannot be applied to property 'longDescription' in type org.infinispan.query.dsl.embedded.testdomain.hsearch.TransactionHS unless the property is indexed and analyzed.")
    public void testFullTextPhrase() throws Exception {
        super.testFullTextPhrase();
    }
}

