/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.NonLocalIndexingTest")
public class NonLocalIndexingTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = NonLocalIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)this.transactionsEnabled());
        builder.indexing().index(Index.ALL).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, builder);
    }

    protected boolean transactionsEnabled() {
        return false;
    }

    public void testQueryAfterAddingNewNode() throws Exception {
        this.store("Astronaut", new Person("Astronaut", "is asking his timezone", 32), (Cache<Object, Object>)this.cache(0));
        this.assertFind("timezone", 1);
        this.assertFind("asking", 1);
        this.assertFind("cat", 0);
        this.store("Webdeveloper", new Person("Webdeveloper", "is confused by the timezone concept", 32), (Cache<Object, Object>)this.cache(1));
        this.assertFind("cat", 0);
        this.assertFind("timezone", 2);
        this.store("Astronaut", new Person("Astronaut", "thinks about his cat", 32), (Cache<Object, Object>)this.cache(1));
        this.assertFind("cat", 1);
        this.assertFind("timezone", 1);
        this.store("Astronaut", new AnotherGrassEater("Astronaut", "is having a hard time to find grass"), (Cache<Object, Object>)this.cache(1));
        this.assertFind("cat", 0);
        this.assertFind("grass", 1);
    }

    private void assertFind(String keyword, int expectedCount) {
        NonLocalIndexingTest.assertFind(this.cache(0), keyword, expectedCount);
        NonLocalIndexingTest.assertFind(this.cache(1), keyword, expectedCount);
    }

    private static void assertFind(Cache cache, String keyword, int expectedCount) {
        SearchManager queryFactory = Search.getSearchManager((Cache)cache);
        TermQuery luceneQuery = new TermQuery(new Term("blurb", keyword));
        CacheQuery cacheQuery = queryFactory.getQuery((Query)luceneQuery, new Class[0]);
        int resultSize = cacheQuery.getResultSize();
        Assert.assertEquals((int)resultSize, (int)expectedCount);
    }

    private void store(final String key, final Object value, final Cache<Object, Object> cache) throws Exception {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache.put((Object)key, value);
                return null;
            }
        };
        if (this.transactionsEnabled()) {
            TestingUtil.withTx((TransactionManager)cache.getAdvancedCache().getTransactionManager(), (Callable)callable);
        } else {
            callable.call();
        }
    }
}

