/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.security.Security;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)(System.getSecurityManager() != null ? AccessController.doPrivileged(action) : Security.doPrivileged(action));
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getComponentRegistry());
    }

    static SearchManager getCacheSearchManager(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> Search.getSearchManager(cache));
    }
}

