/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.statetransfer;

import java.util.List;
import org.apache.lucene.queryparser.classic.ParseException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;

public abstract class BaseReIndexingTest
extends MultipleCacheManagersTest {
    protected Person[] persons;
    protected ConfigurationBuilder builder;

    protected abstract void configureCache(ConfigurationBuilder var1);

    protected void createCacheManagers() throws Throwable {
        this.builder = BaseReIndexingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        this.builder.indexing().index(Index.ALL).addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.configureCache(this.builder);
        this.createClusteredCaches(2, this.builder);
    }

    private EmbeddedCacheManager createCacheManager() {
        return this.addClusterEnabledCacheManager(this.builder, new TransportFlags().withMerge(true));
    }

    protected void executeSimpleQuery(Cache<String, Person> cache) throws ParseException {
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(cache, "blurb", "playing");
        List found = cacheQuery.list();
        int elems = found.size();
        AssertJUnit.assertEquals((int)1, (int)elems);
        Object val = found.get(0);
        Person expectedPerson = this.persons[0];
        AssertJUnit.assertEquals((Object)expectedPerson, val);
    }

    protected void loadCacheEntries(Cache<String, Person> cache) {
        Person person1 = new Person();
        person1.setName("NavinSurtani");
        person1.setBlurb("Likes playing WoW");
        person1.setAge(45);
        Person person2 = new Person();
        person2.setName("BigGoat");
        person2.setBlurb("Eats grass");
        person2.setAge(30);
        Person person3 = new Person();
        person3.setName("MiniGoat");
        person3.setBlurb("Eats cheese");
        person3.setAge(35);
        Person person4 = new Person();
        person4.setName("MightyGoat");
        person4.setBlurb("Also eats grass");
        person4.setAge(66);
        this.persons = new Person[]{person1, person2, person3, person4};
        cache.put((Object)person1.getName(), (Object)person1);
        cache.put((Object)person2.getName(), (Object)person2);
        cache.put((Object)person3.getName(), (Object)person3);
        cache.put((Object)person4.getName(), (Object)person4);
    }

    protected void addNodeCheckingContentsAndQuery() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager()){

            public void call() throws Exception {
                Cache newCache = this.cm.getCache();
                TestingUtil.waitForNoRebalance((Cache[])new Cache[]{(Cache)BaseReIndexingTest.this.caches().get(0), (Cache)BaseReIndexingTest.this.caches().get(1), newCache});
                int size = newCache.size();
                AssertJUnit.assertEquals((int)4, (int)size);
                for (int i = 0; i < size; ++i) {
                    AssertJUnit.assertEquals((Object)BaseReIndexingTest.this.persons[i], (Object)newCache.get((Object)BaseReIndexingTest.this.persons[i].getName()));
                }
                BaseReIndexingTest.this.executeSimpleQuery((Cache<String, Person>)newCache);
            }
        });
    }
}

