/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.affinity.BaseAffinityTest;
import org.infinispan.query.affinity.RpcCollector;
import org.infinispan.query.affinity.RpcDetail;
import org.infinispan.query.affinity.TrackingRpcManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.AffinityRpcTest")
public class AffinityRpcTest
extends BaseAffinityTest {
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, this.getDefaultCacheConfigBuilder());
    }

    @Override
    protected Configuration getLockCacheConfig() {
        return this.getBaseIndexCacheConfig(CacheMode.DIST_SYNC).build();
    }

    @Override
    protected int getNumOwners() {
        return 1;
    }

    public void shouldAvoidRpcsDuringIndexing() throws Exception {
        String[] indexCaches = new String[]{"LuceneIndexesData", "LuceneIndexesMetadata", "LuceneIndexesLocking"};
        RpcCollector rpcCollector = new RpcCollector();
        this.cacheManagers.stream().flatMap(cm -> cm.getCacheNames().stream().map(arg_0 -> ((EmbeddedCacheManager)cm).getCache(arg_0))).forEach(cache -> this.replaceRpcManager((Cache<?, ?>)cache, rpcCollector));
        this.waitForClusterToForm(indexCaches);
        this.populate(1, 100);
        Arrays.stream(indexCaches).forEach(c -> this.assertNoRPCs((String)c, rpcCollector));
    }

    private void assertNoRPCs(String cacheName, RpcCollector rpcCollector) {
        Set<RpcDetail> rpcsForCache = rpcCollector.getRpcsForCache(cacheName);
        int numRpcs = rpcsForCache.size();
        Assert.assertEquals((int)numRpcs, (int)0, (String)MessageFormat.format("Cache {0} has done {1} Rpcs", cacheName, numRpcs));
    }

    private void replaceRpcManager(Cache<?, ?> cache, RpcCollector rpcCollector) {
        RpcManager current = cache.getAdvancedCache().getRpcManager();
        TrackingRpcManager replacement = new TrackingRpcManager(current, rpcCollector, cache.getName());
        TestingUtil.replaceComponent(cache, RpcManager.class, (Object)replacement, (boolean)true);
    }
}

