/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.jmx;

import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.jmx.QueryMBeanTest")
public class QueryMBeanTest
extends SingleCacheManagerTest {
    static final String JMX_DOMAIN = QueryMBeanTest.class.getSimpleName();
    static final String CACHE_NAME = "queryable-cache";
    MBeanServer server;
    private int numberOfEntries = 100;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)JMX_DOMAIN);
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        cm.defineConfiguration(CACHE_NAME, builder.build());
        return cm;
    }

    protected void setup() throws Exception {
        super.setup();
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
    }

    public void testQueryStatsMBean() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName name = this.getQueryStatsObjectName(JMX_DOMAIN, CACHE_NAME);
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(name));
        AssertJUnit.assertFalse((boolean)((Boolean)this.server.getAttribute(name, "StatisticsEnabled")));
        this.server.setAttribute(name, new Attribute("StatisticsEnabled", true));
        AssertJUnit.assertTrue((boolean)((Boolean)this.server.getAttribute(name, "StatisticsEnabled")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryStats() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName name = this.getQueryStatsObjectName(JMX_DOMAIN, CACHE_NAME);
        try {
            AssertJUnit.assertTrue((boolean)this.server.isRegistered(name));
            if (!((Boolean)this.server.getAttribute(name, "StatisticsEnabled")).booleanValue()) {
                this.server.setAttribute(name, new Attribute("StatisticsEnabled", true));
            }
            Cache cache = this.cacheManager.getCache(CACHE_NAME);
            SearchManager searchManager = Search.getSearchManager((Cache)cache);
            AssertJUnit.assertTrue((boolean)searchManager.getStatistics().isStatisticsEnabled());
            for (int i = 0; i < this.numberOfEntries; ++i) {
                Person person = new Person();
                person.setName("key" + i);
                person.setAge(i);
                person.setBlurb("value " + i);
                person.setNonSearchableField("i: " + i);
                cache.put((Object)("key" + i), (Object)person);
            }
            AssertJUnit.assertTrue((boolean)searchManager.getStatistics().isStatisticsEnabled());
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "SearchQueryExecutionCount"));
            QueryParser queryParser = TestQueryHelperFactory.createQueryParser("blurb");
            Query luceneQuery = queryParser.parse("value");
            CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[0]);
            List found = cacheQuery.list();
            AssertJUnit.assertEquals((Object)1L, (Object)this.server.getAttribute(name, "SearchQueryExecutionCount"));
            AssertJUnit.assertEquals((int)this.numberOfEntries, (int)found.size());
            AssertJUnit.assertEquals((Object)this.numberOfEntries, (Object)this.server.invoke(name, "getNumberOfIndexedEntities", new Object[]{Person.class.getCanonicalName()}, new String[]{String.class.getCanonicalName()}));
            AssertJUnit.assertEquals((int)1, (int)searchManager.getStatistics().indexedEntitiesCount().size());
            AnotherGrassEater anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
            cache.put((Object)"key101", (Object)anotherGrassEater);
            cacheQuery = searchManager.getQuery(luceneQuery, new Class[0]);
            found = cacheQuery.list();
            AssertJUnit.assertEquals((int)this.numberOfEntries, (int)found.size());
            AssertJUnit.assertEquals((Object)1, (Object)this.server.invoke(name, "getNumberOfIndexedEntities", new Object[]{AnotherGrassEater.class.getCanonicalName()}, new String[]{String.class.getCanonicalName()}));
            Set classNames = (Set)this.server.getAttribute(name, "IndexedClassNames");
            AssertJUnit.assertEquals((int)2, (int)classNames.size());
            AssertJUnit.assertTrue((String)"The set should contain the Person class name.", (boolean)classNames.contains(Person.class.getCanonicalName()));
            AssertJUnit.assertTrue((String)"The set should contain the AnotherGrassEater class name.", (boolean)classNames.contains(AnotherGrassEater.class.getCanonicalName()));
            AssertJUnit.assertEquals((int)2, (int)searchManager.getStatistics().indexedEntitiesCount().size());
            AssertJUnit.assertTrue((String)"The query execution total time should be > 0.", ((Long)this.server.getAttribute(name, "SearchQueryTotalTime") > 0L ? 1 : 0) != 0);
            AssertJUnit.assertEquals((Object)2L, (Object)this.server.getAttribute(name, "SearchQueryExecutionCount"));
            AssertJUnit.assertEquals((Object)"blurb:value", (Object)this.server.getAttribute(name, "SearchQueryExecutionMaxTimeQueryString"));
            AssertJUnit.assertTrue(((Long)this.server.getAttribute(name, "SearchQueryExecutionMaxTime") > 0L ? 1 : 0) != 0);
            AssertJUnit.assertTrue(((Long)this.server.getAttribute(name, "SearchQueryExecutionAvgTime") > 0L ? 1 : 0) != 0);
            this.server.invoke(name, "clear", new Object[0], new String[0]);
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "SearchQueryExecutionCount"));
            AssertJUnit.assertEquals((Object)"", (Object)this.server.getAttribute(name, "SearchQueryExecutionMaxTimeQueryString"));
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "SearchQueryExecutionMaxTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "SearchQueryExecutionAvgTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "ObjectsLoadedCount"));
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "ObjectLoadingTotalTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "ObjectLoadingExecutionMaxTime"));
            AssertJUnit.assertEquals((Object)0L, (Object)this.server.getAttribute(name, "ObjectLoadingExecutionAvgTime"));
        }
        finally {
            this.server.setAttribute(name, new Attribute("StatisticsEnabled", false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJmxUnregistration() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName queryStatsObjectName = this.getQueryStatsObjectName(JMX_DOMAIN, CACHE_NAME);
        Set<ObjectName> matchingNames = this.server.queryNames(new ObjectName(JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
        AssertJUnit.assertEquals((int)1, (int)matchingNames.size());
        AssertJUnit.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
        EmbeddedCacheManager cm2 = null;
        try {
            ConfigurationBuilder defaultCacheConfig2 = new ConfigurationBuilder();
            defaultCacheConfig2.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT").jmxStatistics().enable();
            cm2 = TestCacheManagerFactory.createClusteredCacheManagerEnforceJmxDomain((String)"cm2", (String)JMX_DOMAIN, (boolean)true, (boolean)true, (ConfigurationBuilder)defaultCacheConfig2, (MBeanServerLookup)new PerThreadMBeanServerLookup());
            cm2.defineConfiguration(CACHE_NAME, defaultCacheConfig2.build());
            cm2.getCache(CACHE_NAME);
            matchingNames = this.server.queryNames(new ObjectName(JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
            AssertJUnit.assertEquals((int)2, (int)matchingNames.size());
            AssertJUnit.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm2});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm2});
        matchingNames = this.server.queryNames(new ObjectName(JMX_DOMAIN + ":type=Query,component=Statistics,cache=" + ObjectName.quote(CACHE_NAME) + ",*"), null);
        AssertJUnit.assertEquals((int)1, (int)matchingNames.size());
        AssertJUnit.assertTrue((boolean)matchingNames.contains(queryStatsObjectName));
    }

    private ObjectName getQueryStatsObjectName(String jmxDomain, String cacheName) {
        String cacheManagerName = this.cacheManager.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
        try {
            return new ObjectName(jmxDomain + ":type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName) + ",component=Statistics");
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Malformed object name", (Throwable)e);
        }
    }
}

